/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.listeners;

import javax.jbi.JBIException;
import org.ow2.petals.bc.ejb.EjbComponent;
import org.ow2.petals.bc.ejb.service.EjbService;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;

public class EjbBcJbiListener
extends AbstractJBIListener {
    public boolean onJBIMessage(Exchange exchange) {
        if (exchange == null) {
            this.getLogger().severe("Receive a null message exchange");
            return true;
        }
        if (!exchange.isActiveStatus() || exchange.getFault() != null) {
            this.getLogger().finest("Receive an ack or a Fault, skip it");
            return true;
        }
        try {
            EjbService service = ((EjbComponent)this.getComponent()).getEjbService();
            service.callEjb(this.getProvides(), exchange);
        }
        catch (JBIException ex) {
            this.getLogger().severe(ex.getMessage());
            if (exchange.isInOnlyPattern()) {
                exchange.setError((Exception)((Object)ex));
            }
            if (exchange.isInOutPattern()) {
                exchange.setError((Exception)((Object)ex));
            }
            if (exchange.isRobustInOnlyPattern()) {
                exchange.setError((Exception)((Object)ex));
            }
            if (exchange.isInOptionalOutPattern()) {
                exchange.setError((Exception)((Object)ex));
            }
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Unable to propagate the exception : ");
            errorSB.append(ex.getMessage());
            errorSB.append(": Invalid MEP");
            this.getLogger().severe(errorSB.toString());
            return true;
        }
        return true;
    }
}

