/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.su;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.bc.ejb.EjbComponent;
import org.ow2.petals.bc.ejb.EjbConnectionPoolElement;
import org.ow2.petals.bc.ejb.configuration.EjbConfiguration;
import org.ow2.petals.bc.ejb.configuration.EjbConfigurationBuilder;
import org.ow2.petals.bc.ejb.exceptions.ConfigurationException;
import org.ow2.petals.bc.ejb.exceptions.ConnectionException;
import org.ow2.petals.bc.ejb.exceptions.EjbConnectionPoolException;
import org.ow2.petals.bc.ejb.service.EjbConnection;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.BindingComponentServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.ow2.petals.databinding.jaxb.DataBindingException;
import org.ow2.petals.databinding.jaxb.ServiceFactory;
import org.ow2.petals.databinding.jaxb.service.Service;
import org.ow2.petals.databinding.jaxb.tools.JaxbClassGenerator;

public class EJBServiceUnitManager
extends BindingComponentServiceUnitManager {
    private EjbComponent component;
    private Logger logger;

    public EJBServiceUnitManager(Logger logger, EjbComponent ejbComponent) {
        super((AbstractBindingComponent)ejbComponent);
        this.logger = logger;
        this.component = ejbComponent;
    }

    private String getSURootPath(String serviceUnitName) {
        return ((ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName)).getInstallRoot();
    }

    private Jbi getSUDescriptor(String serviceUnitName) {
        return ((ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName)).getDescriptor();
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        List providesList = jbiDescriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            String wsdlFileName = provides.getWsdl();
            String serviceName = provides.getServiceName().getLocalPart();
            ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(provides);
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
            try {
                EjbConfiguration ejbConfiguration = EjbConfigurationBuilder.buildEjbConfiguration(extensions, wsdlFileName, serviceName);
                this.registerEjb(provides, ejbConfiguration, this.getSURootPath(serviceUnitName));
            }
            catch (ConnectionException e) {
                throw new PEtALSCDKException("Can't deploy the service unit: ", (Throwable)e);
            }
            catch (EjbConnectionPoolException e) {
                throw new PEtALSCDKException("Can't deploy the service unit: ", (Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new PEtALSCDKException("Can't deploy the service unit: ", (Throwable)e);
            }
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.getSUDescriptor(serviceUnitName);
        if (descriptor != null) {
            List providesList = descriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                try {
                    this.component.getEjbConnectionPool().removeEjb(provides);
                }
                catch (EjbConnectionPoolException ex) {
                    throw new PEtALSCDKException("Can't undeploy the service unit: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEjb(Provides provides, EjbConfiguration configuration, String suRootPath) throws ConnectionException, PEtALSCDKException, EjbConnectionPoolException, ConfigurationException {
        ClassLoader suClassLoader = this.createSUClassLoader(suRootPath);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(suClassLoader);
        try {
            EjbConnection ejbConnection = new EjbConnection(configuration, suClassLoader, this.component.getLogger());
            Object ejb = ejbConnection.retrieveObject(configuration);
            Service databindingService = this.createJAXBDatabinding(configuration, suClassLoader, ejb.getClass(), suRootPath);
            EjbConnectionPoolElement poolElement = new EjbConnectionPoolElement(configuration, ejb, databindingService, suClassLoader);
            this.component.getEjbConnectionPool().addEjb(provides, poolElement);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private Service createJAXBDatabinding(EjbConfiguration configuration, ClassLoader suClassLoader, Class<?> ejbServiceClass, String suRootPath) throws PEtALSCDKException, ConfigurationException {
        Properties properties = (Properties)System.getProperties().clone();
        Service databindingService = null;
        try {
            String wsdlFileName = configuration.getDatabindingElement().getWsdlFileName();
            String serviceName = configuration.getDatabindingElement().getServiceName();
            URL[] componentClassPath = ClassLoaderUtil.getUrls((String)this.component.getContext().getInstallRoot());
            ArrayList<String> classPath = new ArrayList<String>();
            for (URL url : componentClassPath) {
                classPath.add(url.getPath());
            }
            String wsdlFilePath = suRootPath + File.separator + wsdlFileName;
            String jaxbBaseDir = suRootPath + serviceName + "-jaxb";
            new File(jaxbBaseDir).mkdirs();
            JaxbClassGenerator.generateJaxbClass((String)wsdlFilePath, (String)jaxbBaseDir, (String)serviceName);
            JaxbClassGenerator.compileJaxbClass((String)jaxbBaseDir, (String)serviceName, classPath);
            String jaxbClassesUrl = "file://" + jaxbBaseDir + "/target/classes/";
            ServiceFactory serviceFactory = ServiceFactory.getInstance();
            databindingService = serviceFactory.crateService(wsdlFilePath, jaxbClassesUrl, suClassLoader, ejbServiceClass);
        }
        catch (DataBindingException ex) {
            StringBuilder errorSB = new StringBuilder("Databinding error : ");
            errorSB.append("can't create the databinding service : ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new PEtALSCDKException(errorSB.toString(), (Throwable)ex);
        }
        finally {
            System.setProperties(properties);
        }
        return databindingService;
    }

    private ClassLoader createSUClassLoader(String suRootPath) {
        return ClassLoaderUtil.createClassLoader((String)suRootPath, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }
}

