/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.fs;

import java.io.File;
import java.io.IOException;
import java.util.Random;

public final class FileSystemHelper {
    private static final Random random = new Random();

    private FileSystemHelper() {
    }

    private static final File getSystemTempDir() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        assert (tmpDirPath != null);
        File tmpDir = new File(tmpDirPath);
        assert (tmpDir != null);
        return tmpDir;
    }

    public static File createTempDir() throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), "tmp");
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), prefix);
    }

    public static File createTempDir(File parentDir, String prefix) throws IOException {
        File tempDir = null;
        while ((tempDir = new File(parentDir, prefix + random.nextLong())).exists()) {
        }
        if (!tempDir.mkdir()) {
            throw new IOException(String.format("Impossible to create temp dir '%s'", tempDir.getAbsolutePath()));
        }
        tempDir.deleteOnExit();
        return tempDir;
    }
}

