/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.compile.jdt;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.objectweb.fractal.juliac.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName) {
        this.contents = contents;
        this.fileName = fileName.toCharArray();
        this.packageName = packageName;
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent((File)new File(new String(this.fileName)), (String)this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int end;
            int separator;
            int start = CharOperation.lastIndexOf((char)'/', (char[])this.fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf((char)'\\', (char[])this.fileName)) {
                start = CharOperation.lastIndexOf((char)'\\', (char[])this.fileName) + 1;
            }
            if ((separator = CharOperation.indexOf((char)'|', (char[])this.fileName) + 1) > start) {
                start = separator;
            }
            if (!((end = CharOperation.lastIndexOf((char)'$', (char[])this.fileName)) != -1 && Util.isClassFileName((char[])this.fileName) || (end = CharOperation.lastIndexOf((char)'.', (char[])this.fileName)) != -1)) {
                end = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray((char[])this.fileName, (int)start, (int)end);
        }
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "CompilationUnit: " + new String(this.fileName);
    }

    static Map<ICompilationUnit, SourceFile> getICompilationUnitMap(List<SourceFile> sfs) throws IOException {
        HashMap<ICompilationUnit, SourceFile> units = new HashMap<ICompilationUnit, SourceFile>();
        for (SourceFile sf : sfs) {
            ICompilationUnit unit = BasicCompilationUnit.getUnit(sf);
            units.put(unit, sf);
        }
        return units;
    }

    private static ICompilationUnit getUnit(SourceFile sf) throws IOException {
        String qname = sf.getQname();
        String fileName = sf.getName();
        char[] content = sf.getContent();
        String[] tmp = qname.split("[.]");
        char[][] packageName = new char[tmp.length - 1][];
        for (int i = 0; i < tmp.length - 1; ++i) {
            packageName[i] = tmp[i].toCharArray();
        }
        BasicCompilationUnit unit = new BasicCompilationUnit(content, packageName, fileName);
        return unit;
    }
}

