/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.compile.jdt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilerRequestorImpl
implements ICompilerRequestor {
    private Map<ICompilationUnit, SourceFile> units;
    private CompilationResult result;
    private List<ClassFile> classFiles;

    CompilerRequestorImpl() {
    }

    void init(Map<ICompilationUnit, SourceFile> units) {
        this.units = units;
        this.classFiles = new ArrayList<ClassFile>();
    }

    public void acceptResult(CompilationResult result) {
        ClassFile[] cfs;
        this.result = result;
        if (result.hasErrors()) {
            ICompilationUnit icu = result.compilationUnit;
            SourceFile sf = this.units.get(icu);
            StringBuffer msg = new StringBuffer();
            if (sf == null) {
                char[][] packageNames;
                for (char[] packageName : packageNames = icu.getPackageName()) {
                    msg.append(packageName);
                    msg.append('.');
                }
                char[] mainTypeName = icu.getMainTypeName();
                msg.append(mainTypeName);
                msg.append(" (");
                char[] fileName = icu.getFileName();
                msg.append(fileName);
                msg.append(')');
            } else {
                msg.append(sf.toString());
            }
            msg.append(':');
            for (int i = 0; i < result.problemCount; ++i) {
                CategorizedProblem cp = result.problems[i];
                msg.append("\n  line ");
                msg.append(cp.getSourceLineNumber());
                msg.append(": ");
                msg.append(cp.getMessage());
            }
            Juliac.reportError((String)msg.toString());
        }
        for (ClassFile cf : cfs = result.getClassFiles()) {
            this.classFiles.add(cf);
        }
    }

    CompilationResult getResult() {
        return this.result;
    }

    List<ClassFile> getClassFiles() {
        return this.classFiles;
    }
}

