/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.databinding.jaxb;

import com.ibm.wsdl.PartImpl;
import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12OperationImpl;
import com.sun.tools.xjc.api.XJC;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.ow2.petals.databinding.jaxb.DataBindingException;
import org.ow2.petals.databinding.jaxb.Registry;
import org.ow2.petals.databinding.jaxb.serialization.ServiceMarshaller;
import org.ow2.petals.databinding.jaxb.serialization.ServiceUnmarshaller;
import org.ow2.petals.databinding.jaxb.service.Message;
import org.ow2.petals.databinding.jaxb.service.Operation;
import org.ow2.petals.databinding.jaxb.service.Service;
import org.ow2.petals.databinding.jaxb.tools.Util;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceFactory {
    private static ServiceFactory wsdl2JbiFactory;

    public static ServiceFactory getInstance() {
        if (wsdl2JbiFactory == null) {
            return new ServiceFactory();
        }
        return wsdl2JbiFactory;
    }

    public Service crateService(String wsdlUrl, String jaxbClassJar, ClassLoader serviceClassLoader, Class<?> serviceClass) throws DataBindingException {
        Service _service = new Service();
        this.setWsdlServiceInfo(wsdlUrl, _service);
        this.setJaxbInfo(jaxbClassJar, _service, serviceClassLoader);
        this.addMethodSignature(_service, serviceClass);
        return _service;
    }

    private void setWsdlServiceInfo(String wsdlUrl, Service _service) throws DataBindingException {
        WSDLFactory wsdlFactory = null;
        Definition definition = null;
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e1) {
            throw new DataBindingException("Error occurred when creating WSDLFactory", e1);
        }
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        try {
            definition = wsdlReader.readWSDL(wsdlUrl);
            Map services = definition.getServices();
            Set serviceNames = services.keySet();
            List exts = definition.getTypes().getExtensibilityElements();
            for (Object o : exts) {
                Schema el = (Schema)o;
                NamedNodeMap atts = el.getElement().getAttributes();
                Node targetNS = atts.getNamedItem("targetNamespace");
                NodeList n = el.getElement().getChildNodes();
                for (int i = 0; i < n.getLength(); ++i) {
                    Node no = n.item(i);
                    if (!"complexType".equals(no.getLocalName())) continue;
                    NamedNodeMap atts2 = no.getAttributes();
                    Node name = atts2.getNamedItem("name");
                    _service.addClassMapping(name.getNodeValue(), XJC.getDefaultPackageName((String)targetNS.getNodeValue()));
                }
            }
            javax.wsdl.Service service = (javax.wsdl.Service)services.get(serviceNames.iterator().next());
            _service.setServiceName(service.getQName());
            Map ports = service.getPorts();
            Set portNames = ports.keySet();
            for (String portName : portNames) {
                if (ports.size() > 1 && !portName.endsWith("Soap")) continue;
                Port port = (Port)ports.get(portName);
                Binding binding = port.getBinding();
                _service.setInterfaceName(binding.getPortType().getQName());
                List bindingOperations = binding.getBindingOperations();
                for (BindingOperation bindingOperation : bindingOperations) {
                    Operation serviceOperation = new Operation();
                    serviceOperation.setServiceOfOperation(_service);
                    javax.wsdl.Operation operation = bindingOperation.getOperation();
                    serviceOperation.setOperationName(operation.getName());
                    Message inputMessage = new Message();
                    Input input = operation.getInput();
                    javax.wsdl.Message message = input.getMessage();
                    if (message.getParts().size() != 1) {
                        throw new DataBindingException("The message element has more than one part, only the document/literal wrapped WSDL style is supported ");
                    }
                    PartImpl partImpl = (PartImpl)message.getParts().values().iterator().next();
                    String partName = partImpl.getName();
                    inputMessage.setMessageName(message.getPart(partName).getElementName());
                    inputMessage.setMessageTypeName(ServiceFactory.getMessageType(definition, message.getPart(partName).getElementName()));
                    serviceOperation.setInputMessage(inputMessage);
                    Message outputMessage = new Message();
                    Output output = operation.getOutput();
                    if (output != null) {
                        message = output.getMessage();
                        if (message.getParts().size() != 1) {
                            throw new DataBindingException("The message element has more than one part, only the document/literal wrapped WSDL style is supported ");
                        }
                        partImpl = (PartImpl)message.getParts().values().iterator().next();
                        partName = partImpl.getName();
                        outputMessage.setMessageName(message.getPart(partName).getElementName());
                        outputMessage.setMessageTypeName(ServiceFactory.getMessageType(definition, message.getPart(partName).getElementName()));
                        serviceOperation.setOutputMessage(outputMessage);
                    }
                    Map faults = operation.getFaults();
                    for (String faultName : faults.keySet()) {
                        Fault fault = (Fault)faults.get(faultName);
                        Message faultMessage = new Message();
                        message = fault.getMessage();
                        partImpl = (PartImpl)message.getParts().values().iterator().next();
                        partName = partImpl.getName();
                        faultMessage.setMessageName(message.getQName());
                        faultMessage.setMessageTypeName(ServiceFactory.getMessageType(definition, message.getPart(partName).getElementName()));
                        serviceOperation.getOperationFaults().add(faultMessage);
                    }
                    List extensions = bindingOperation.getExtensibilityElements();
                    for (Object extension : extensions) {
                        String soapAction;
                        SOAPOperationImpl soapOperation;
                        if (extension instanceof SOAPOperationImpl) {
                            soapOperation = (SOAPOperationImpl)extension;
                            soapAction = soapOperation.getSoapActionURI();
                            serviceOperation.setSoapActionName(soapAction);
                            continue;
                        }
                        if (!(extensions instanceof SOAP12OperationImpl)) continue;
                        soapOperation = (SOAP12OperationImpl)extension;
                        soapAction = soapOperation.getSoapActionURI();
                        serviceOperation.setSoapActionName(soapAction);
                    }
                    _service.getOperations().add(serviceOperation);
                }
            }
        }
        catch (Exception e) {
            throw new DataBindingException("WSDL parsing error, can't get service inofrmationsFrom the WSDL", e);
        }
    }

    private void setJaxbInfo(String jaxbClassJar, Service _service, ClassLoader serviceClassLoader) throws DataBindingException {
        ServiceMarshaller serviceMarshaller = new ServiceMarshaller();
        serviceMarshaller.setClassPackageMapping(_service.getClassPackageMapping());
        ServiceUnmarshaller serviceUnmarshaller = new ServiceUnmarshaller();
        try {
            URLClassLoader jaxbClassLoader = new URLClassLoader(new URL[]{new URL(jaxbClassJar)}, this.getClass().getClassLoader());
            serviceMarshaller.setJaxbClassLoader(jaxbClassLoader);
            serviceUnmarshaller.setServiceClassLoader(serviceClassLoader);
            serviceUnmarshaller.setJaxbClassLoader(jaxbClassLoader);
            Registry registry = new Registry();
            List<Operation> serviceOperations = _service.getOperations();
            for (Operation serviceOperation : serviceOperations) {
                Field[] fields;
                Message inputMessage = serviceOperation.getInputMessage();
                String messageTypeName = Util.upperFirstCase(inputMessage.getMessageTypeName().getLocalPart());
                String packageName = XJC.getDefaultPackageName((String)inputMessage.getMessageTypeName().getNamespaceURI());
                String jaxbMessageClassName = packageName + "." + messageTypeName;
                if (!registry.getMarshallingObjects().containsKey(inputMessage.getMessageTypeName().getNamespaceURI())) {
                    registry.addEntry(inputMessage.getMessageTypeName().getNamespaceURI(), packageName, jaxbClassLoader);
                }
                Class<?> jaxbMessageClass = jaxbClassLoader.loadClass(jaxbMessageClassName);
                inputMessage.setMessageJaxbClass(jaxbMessageClass);
                for (Field field : fields = jaxbMessageClass.getDeclaredFields()) {
                    inputMessage.getMessageParts().put(field.getName(), field.getType());
                }
                Message outputMessage = serviceOperation.getOutputMessage();
                if (outputMessage != null) {
                    messageTypeName = Util.upperFirstCase(outputMessage.getMessageTypeName().getLocalPart());
                    packageName = XJC.getDefaultPackageName((String)outputMessage.getMessageTypeName().getNamespaceURI());
                    jaxbMessageClassName = packageName + "." + messageTypeName;
                    if (!registry.getMarshallingObjects().containsKey(outputMessage.getMessageTypeName().getNamespaceURI())) {
                        registry.addEntry(outputMessage.getMessageTypeName().getNamespaceURI(), packageName, jaxbClassLoader);
                    }
                    jaxbMessageClass = jaxbClassLoader.loadClass(jaxbMessageClassName);
                    outputMessage.setMessageJaxbClass(jaxbMessageClass);
                    for (Field field : fields = jaxbMessageClass.getDeclaredFields()) {
                        String filedName = field.getName();
                        if (filedName.equals("_return")) {
                            filedName = filedName.substring(1);
                        }
                        outputMessage.getMessageParts().put(filedName, field.getType());
                    }
                }
                List<Message> faults = serviceOperation.getOperationFaults();
                for (Message faultMessage : faults) {
                    messageTypeName = Util.upperFirstCase(faultMessage.getMessageTypeName().getLocalPart());
                    packageName = XJC.getDefaultPackageName((String)faultMessage.getMessageTypeName().getNamespaceURI());
                    jaxbMessageClassName = packageName + "." + messageTypeName;
                    if (!registry.getMarshallingObjects().containsKey(faultMessage.getMessageTypeName().getNamespaceURI())) {
                        registry.addEntry(faultMessage.getMessageTypeName().getNamespaceURI(), packageName, jaxbClassLoader);
                    }
                    jaxbMessageClass = jaxbClassLoader.loadClass(jaxbMessageClassName);
                    faultMessage.setMessageJaxbClass(jaxbMessageClass);
                    for (Field field : fields = jaxbMessageClass.getDeclaredFields()) {
                        faultMessage.getMessageParts().put(field.getName(), field.getType());
                    }
                }
            }
            _service.setRegistry(registry);
            _service.setServiceUnmarshaller(serviceUnmarshaller);
            _service.setServiceMarshaller(serviceMarshaller);
        }
        catch (Exception e) {
            throw new DataBindingException(" Can't extract the DataBinding inofrmations", e);
        }
    }

    private void addMethodSignature(Service service, Class<?> serviceClass) {
        List<Operation> serviceOperations = service.getOperations();
        for (Operation serviceOperation : serviceOperations) {
            Method[] methods;
            for (Method method : methods = serviceClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(serviceOperation.getOperationName())) continue;
                serviceOperation.setParameterTypes(method.getParameterTypes());
                serviceOperation.setGenericParameterTypes(method.getGenericParameterTypes());
                if (!method.getReturnType().equals(Void.TYPE)) {
                    serviceOperation.setReturnType(method.getReturnType());
                    serviceOperation.setGenericReturnType(method.getGenericReturnType());
                }
                serviceOperation.setExceptionType(method.getExceptionTypes());
            }
        }
    }

    private static QName getMessageType(Definition wsdlDefintion, QName messageElement) {
        List exts = wsdlDefintion.getTypes().getExtensibilityElements();
        for (Object o : exts) {
            Schema rootSchema = (Schema)o;
            QName messageType = ServiceFactory.getMessageTypeFromSchema(rootSchema, messageElement, wsdlDefintion);
            if (messageType == null) continue;
            return messageType;
        }
        return null;
    }

    private static QName getMessageTypeFromSchema(Schema schema, QName messageElement, Definition wsdlDefintion) {
        NodeList nodeList = schema.getElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String typeValueLocalPart;
            String typeValueNameSpace;
            String nodeValueLocalPart;
            String nodeValueNameSpace;
            Node currentNode = nodeList.item(i);
            if (!"element".equals(currentNode.getLocalName())) continue;
            NamedNodeMap atts2 = currentNode.getAttributes();
            Node name = atts2.getNamedItem("name");
            String nodeValue = name.getNodeValue();
            if (!nodeValue.contains(":")) {
                nodeValueNameSpace = ServiceFactory.getNameSpaceForPrefix(schema, "targetNamespace", wsdlDefintion);
                nodeValueLocalPart = nodeValue;
            } else {
                String prefix = nodeValue.substring(0, nodeValue.indexOf(58));
                nodeValueNameSpace = ServiceFactory.getNameSpaceForPrefix(schema, prefix, wsdlDefintion);
                nodeValueLocalPart = nodeValue.substring(nodeValue.indexOf(58), nodeValue.length());
            }
            QName currentElementName = new QName(nodeValueNameSpace, nodeValueLocalPart);
            if (!messageElement.equals(currentElementName)) continue;
            Node type = atts2.getNamedItem("type");
            if (type == null) {
                return currentElementName;
            }
            String typeValue = type.getNodeValue();
            if (!typeValue.contains(":")) {
                typeValueNameSpace = ServiceFactory.getNameSpaceForPrefix(schema, "targetNamespace", wsdlDefintion);
                typeValueLocalPart = typeValue;
            } else {
                String prefix = typeValue.substring(0, typeValue.indexOf(58));
                typeValueNameSpace = ServiceFactory.getNameSpaceForPrefix(schema, prefix, wsdlDefintion);
                typeValueLocalPart = typeValue.substring(typeValue.indexOf(58) + 1, typeValue.length());
            }
            return new QName(typeValueNameSpace, typeValueLocalPart);
        }
        Map imports = schema.getImports();
        Set keys = imports.keySet();
        for (String key : keys) {
            Vector importedSchemas = (Vector)imports.get(key);
            for (SchemaImportImpl importedSchema : importedSchemas) {
                QName messageTypeName;
                if (importedSchema.getReferencedSchema() == null || (messageTypeName = ServiceFactory.getMessageTypeFromSchema(importedSchema.getReferencedSchema(), messageElement, wsdlDefintion)) == null) continue;
                return messageTypeName;
            }
        }
        return null;
    }

    private static String getNameSpaceForPrefix(Schema schema, String prefix, Definition wsdlDefinition) {
        NamedNodeMap atts = schema.getElement().getAttributes();
        Node targetNS = prefix.equals("targetNamespace") ? atts.getNamedItem("targetNamespace") : atts.getNamedItem("xmlns:" + prefix);
        if (targetNS == null) {
            if (prefix.equals("targetNamespace")) {
                return wsdlDefinition.getTargetNamespace();
            }
            return (String)wsdlDefinition.getNamespaces().get(prefix);
        }
        return targetNS.getNodeValue();
    }
}

