/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class MessageExchangeAcceptor
extends Thread {
    private Logger logger;
    private DeliveryChannel deliveryChannel;
    private boolean running = false;
    private ThreadPoolExecutor jbiProcessorThreadPool;
    private GenericObjectPool jbiProcessorObjectPool;

    public MessageExchangeAcceptor(AbstractComponent component, ThreadPoolExecutor jbiProcessorThreadPool, GenericObjectPool jbiProcessorObjectPool, Logger logger, ThreadGroup threadGroup, String threadName) {
        super(threadGroup, threadName);
        this.jbiProcessorThreadPool = jbiProcessorThreadPool;
        this.jbiProcessorObjectPool = jbiProcessorObjectPool;
        this.deliveryChannel = component.getChannel();
        this.logger = logger;
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "Starting MessageExchangeAcceptor Thread " + this.getName());
        this.running = true;
        while (this.running) {
            try {
                ExchangeImpl exchange = new ExchangeImpl(this.deliveryChannel.accept());
                this.logger.fine("Accepting a JBI message with Id : " + exchange.getExchangeId());
                MessageExchangeProcessor messageExchangeProcessor = (MessageExchangeProcessor)this.jbiProcessorObjectPool.borrowObject();
                messageExchangeProcessor.setMessageExchange(exchange);
                this.jbiProcessorThreadPool.execute(messageExchangeProcessor);
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (RejectedExecutionException e) {
                this.logger.log(Level.SEVERE, "No more JBI worker available", e);
            }
            catch (Exception e) {
                for (Throwable cause = e; cause != null && this.running; cause = cause.getCause()) {
                    if (!(cause instanceof InterruptedException)) continue;
                    this.running = false;
                    this.logger.fine("Thread '" + this.getName() + "' interrupted, stop accepting JBI messages");
                }
                if (!this.running) continue;
                this.logger.log(Level.INFO, "An unexpected exception occurs during the processing of the JBI acceptor '" + this.getName() + "'", e);
            }
        }
    }
}

