/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineArgs<F extends Enum<F>, O extends Enum<O>> {
    private Set<String> flags = new HashSet<String>();
    private Set<String> options = new HashSet<String>();
    private Map<String, String> values = new HashMap<String, String>();
    private List<String> files = new ArrayList<String>();
    private Map<String, Set<String>> domains = new HashMap<String, Set<String>>();

    public void registerFlag(F flag) throws IllegalArgumentException {
        String key = "--" + ((Enum)flag).toString().toLowerCase();
        if (this.options.contains(key)) {
            String msg = key + " already registered as an option";
            throw new IllegalArgumentException(msg);
        }
        this.flags.add(key);
    }

    public void registerOption(O option) throws IllegalArgumentException {
        String key = "--" + ((Enum)option).toString().toLowerCase();
        if (this.flags.contains(key)) {
            String msg = key + " already registered as a flag";
            throw new IllegalArgumentException(msg);
        }
        this.options.add(key);
    }

    public void registerOption(O option, String[] domain) throws IllegalArgumentException {
        String key = "--" + ((Enum)option).toString().toLowerCase();
        if (this.flags.contains(key)) {
            String msg = key + " already registered as a flag";
            throw new IllegalArgumentException(msg);
        }
        this.options.add(key);
        List<String> list = Arrays.asList(domain);
        HashSet<String> set = new HashSet<String>(list);
        this.domains.put(key, set);
    }

    public boolean isFlagSet(F flag) {
        String key = "--" + ((Enum)flag).toString().toLowerCase();
        return this.values.containsKey(key);
    }

    public String getOptionValue(O option) {
        String key = "--" + ((Enum)option).toString().toLowerCase();
        return this.values.get(key);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void parse(String[] args) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            String msg;
            String arg = args[i];
            String key = arg.toLowerCase();
            if (this.flags.contains(key)) {
                this.values.put(key, null);
                continue;
            }
            if (this.options.contains(key)) {
                Set<String> domain;
                if (i == args.length - 1) {
                    msg = "Missing value for option: " + arg;
                    throw new IllegalArgumentException(msg);
                }
                if (this.domains.containsKey(key) && !(domain = this.domains.get(key)).contains(args[++i])) {
                    String msg2 = "Illegal value " + args[i] + " for option " + key;
                    throw new IllegalArgumentException(msg2);
                }
                this.values.put(key, args[i]);
                continue;
            }
            if (key.charAt(0) == '-') {
                msg = "Illegal option: " + arg;
                throw new IllegalArgumentException(msg);
            }
            this.files.add(arg);
        }
    }
}

