/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.juliac.CompilationRound;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.conf.JuliacConfig;

public class CompilationRounds {
    private List<CompilationRound> rounds = new ArrayList<CompilationRound>();
    private JuliacConfig jconf;

    public CompilationRounds(JuliacConfig jconf) {
        this.jconf = jconf;
    }

    public CompilationRound newCompilationRound() {
        CompilationRound round = new CompilationRound(this, this.jconf);
        this.rounds.add(round);
        return round;
    }

    public CompilationRound getCurrentCompilationRound() {
        int idx = this.rounds.size();
        if (idx == 0) {
            CompilationRound round = this.newCompilationRound();
            return round;
        }
        CompilationRound round = this.rounds.get(idx - 1);
        return round;
    }

    public boolean contains(SourceFile sf) {
        for (CompilationRound round : this.rounds) {
            boolean b = round.contains(sf);
            if (!b) continue;
            return true;
        }
        return false;
    }
}

