/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.control.attribute.CloneableAttributeController;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.juliac.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.ITBasedClassGenerator;
import org.objectweb.fractal.juliac.InitializerClassGenerator;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacLoader;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.plugin.ADLParserSupportItf;
import org.objectweb.fractal.juliac.proxy.AttributeControllerClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.proxy.InterfaceImplementationClassGenerator;
import org.objectweb.fractal.juliac.proxy.LifeCycleSourceCodeGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FCSourceCodeGenerator<T>
implements FCSourceCodeGeneratorItf<T> {
    protected Juliac jc;
    private boolean initialized = false;

    @Override
    public void init(Juliac jc) throws IOException {
        if (this.initialized) {
            String msg = this.getClass().getName() + ".init() has already been called";
            throw new JuliacRuntimeException(msg);
        }
        this.jc = jc;
        JuliacConfig jconf = jc.getJuliacConfig();
        jconf.putInterceptorSourceCodeGenerator("org.objectweb.fractal.julia.asm.LifeCycleCodeGenerator", new LifeCycleSourceCodeGenerator());
        String prop = System.getProperty("julia.config");
        if (prop != null && prop.length() != 0) {
            String[] filenames;
            JuliacLoader loader = jc.getJuliacConfig().getJuliacLoader();
            for (String filename : filenames = prop.split(",")) {
                loader.loadConfigFile(filename);
            }
        }
        this.initialized = true;
    }

    @Override
    public boolean acceptADLDesc(String adl) {
        String adlFileName = adl.replace('.', '/') + ".fractal";
        JuliacConfig jconf = this.jc.getJuliacConfig();
        ClassLoader loader = jconf.getClassLoader();
        InputStream is = loader.getResourceAsStream(adlFileName);
        boolean exist = is != null;
        return exist;
    }

    @Override
    public boolean acceptCtrlDesc(Object controllerDesc) {
        if (!(controllerDesc instanceof String)) {
            return false;
        }
        String ctrlDesc = (String)controllerDesc;
        JuliacLoader loader = this.jc.getJuliacConfig().getJuliacLoader();
        boolean accept = loader.containsTree(ctrlDesc);
        return accept;
    }

    @Override
    public void generate(String adl, String targetname) throws IOException {
        ADLParserSupportItf fractaladl = this.jc.getFractalADL();
        fractaladl.generate(adl, targetname);
    }

    @Override
    public InitializerClassGenerator<T> generate(Type type, Object controllerDesc, Object contentDesc) throws IOException {
        if (!(type instanceof ComponentType)) {
            String msg = "ComponentType instance expected";
            throw new IllegalArgumentException(msg);
        }
        if (!(controllerDesc instanceof String)) {
            String msg = "controllerDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        ComponentType ct = (ComponentType)type;
        String ctrlDesc = (String)controllerDesc;
        String contentClassName = Utils.getContentClassName(ctrlDesc, contentDesc);
        MembraneDesc membraneDesc = this.generateMembraneImpl(ct, ctrlDesc, contentClassName);
        InitializerClassGenerator scg = this.generateInitializerImpl(membraneDesc, ct, contentDesc);
        return scg;
    }

    @Override
    public ProxyClassGenerator getInterfaceClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc) {
        return new InterfaceImplementationClassGenerator(it, membraneDesc, false, this.jc);
    }

    protected ITBasedClassGenerator getInterceptorClassGenerator(String ctrldesc, Map<?, ?> context) {
        boolean mergeable = false;
        InterceptorSourceCodeGenerator[] scgs = this.getInterceptorSourceCodeGenerator(ctrldesc, context, mergeable);
        if (scgs == null) {
            return null;
        }
        ITBasedClassGenerator icg = this.getInterceptorClassGenerator(scgs);
        return icg;
    }

    protected InterceptorSourceCodeGenerator[] getInterceptorSourceCodeGenerator(String ctrldesc, Map<?, ?> context, boolean mergeable) {
        JuliacLoader loader = this.jc.getJuliacConfig().getJuliacLoader();
        String[] asms = loader.getInterceptorCodeGenerator(ctrldesc, context);
        if (asms == null) {
            return null;
        }
        return this.getInterceptorSourceCodeGenerator(asms, mergeable);
    }

    protected InterceptorSourceCodeGenerator[] getInterceptorSourceCodeGenerator(String[] asms, boolean mergeable) throws IllegalArgumentException {
        JuliacConfig jconf = this.jc.getJuliacConfig();
        InterceptorSourceCodeGenerator[] scgs = new InterceptorSourceCodeGenerator[asms.length];
        for (int i = 0; i < asms.length; ++i) {
            String asm = asms[i];
            if (!jconf.containsInterceptorSourceCodeGenerator(asm)) {
                String msg = "No associated source code generator for: " + asm;
                throw new IllegalArgumentException(msg);
            }
            scgs[i] = jconf.getInterceptorSourceCodeGenerator(asm);
            scgs[i].setMergeable(mergeable);
            scgs[i].setJuliac(this.jc);
        }
        return scgs;
    }

    protected Map<String, Tree> getJuliaContextInfo(ComponentType ct) {
        HashMap<String, Tree> context = new HashMap<String, Tree>();
        try {
            InterfaceType it = ct.getFcInterfaceType("attribute-controller");
            String signature = it.getFcItfSignature();
            Tree tree = new Tree(new Tree[]{new Tree("attribute-controller"), new Tree(signature)});
            context.put("attributeControllerInterface", tree);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return context;
    }

    protected abstract InitializerClassGenerator<T> getInitializerClassGenerator();

    protected ITBasedClassGenerator getInterceptorClassGenerator(InterceptorSourceCodeGenerator[] iscgs) {
        return new InterceptorClassGenerator(iscgs, this.jc);
    }

    protected InitializerClassGenerator<T> generateInitializerImpl(MembraneDesc<T> membraneDesc, ComponentType ct, Object contentDesc) throws IOException {
        InitializerClassGenerator<T> scg = this.getInitializerClassGenerator();
        scg.init(this.jc, this, membraneDesc, ct, contentDesc);
        this.jc.generateSourceCode(scg);
        return scg;
    }

    protected void generateInterfaceImpl(InterfaceType[] its, String ctrlDesc) throws IOException {
        for (InterfaceType it : its) {
            this.generateInterfaceImpl(it, ctrlDesc);
            InterfaceType internalit = Utils.newSymetricInterfaceType(it);
            this.generateInterfaceImpl(internalit, ctrlDesc);
        }
    }

    protected void generateInterfaceImpl(InterfaceType it, String ctrlDesc) throws IOException {
        String signature = it.getFcItfSignature();
        UnifiedClass cl = this.jc.create(signature);
        UnifiedClass ac = this.jc.create(AttributeController.class.getName());
        UnifiedClass cac = this.jc.create(CloneableAttributeController.class.getName());
        if (ac.isAssignableFrom(cl) && !cac.isAssignableFrom(cl)) {
            AttributeControllerClassGenerator ascg = new AttributeControllerClassGenerator(it, null, false, this.jc);
            this.jc.generateSourceCode(ascg);
        }
        ProxyClassGenerator iscg = this.getInterfaceClassGenerator(it, null);
        this.jc.generateSourceCode(iscg);
    }

    protected void generateInterceptorImpl(InterfaceType[] its, MembraneDesc<?> membraneDesc) throws IOException {
        ITBasedClassGenerator iscg = membraneDesc.getInterceptorClassGenerator();
        if (iscg == null) {
            return;
        }
        iscg.setMembraneDesc(membraneDesc);
        for (InterfaceType it : its) {
            this.generateInterceptorImpl(it, iscg);
        }
    }

    protected void generateInterceptorImpl(InterfaceType it, ITBasedClassGenerator iscg) throws IOException {
        iscg.setInterfaceType(it);
        if (iscg.match()) {
            this.jc.generateSourceCode(iscg);
        }
    }
}

