/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.ClassGeneratorItf;
import org.objectweb.fractal.juliac.CmdLineArgs;
import org.objectweb.fractal.juliac.CmdLineFlags;
import org.objectweb.fractal.juliac.CmdLineOptions;
import org.objectweb.fractal.juliac.CompilationRound;
import org.objectweb.fractal.juliac.CompilationRounds;
import org.objectweb.fractal.juliac.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.JuliacException;
import org.objectweb.fractal.juliac.JuliacLoggerFormatter;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.conf.Compiler;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.OptLevel;
import org.objectweb.fractal.juliac.plugin.ADLParserSupportItf;
import org.objectweb.fractal.juliac.plugin.CompileSupportItf;
import org.objectweb.fractal.juliac.plugin.SpoonSupportItf;
import org.objectweb.fractal.juliac.ucf.UClassFactory;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassFactoryItf;
import org.objectweb.fractal.juliac.visit.FileSourceCodeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Juliac {
    private JuliacConfig jconf;
    private static final String LOGGER_NAME = "org.objectweb.fractal.juliac";
    private static Logger logger = null;
    private CompileSupportItf compiler;
    private ADLParserSupportItf fractaladl;
    private SpoonSupportItf spoon;
    private List<UnifiedClassFactoryItf> ucfs = new ArrayList<UnifiedClassFactoryItf>();

    public static void main(String[] args) throws IOException, InstantiationException, ClassNotFoundException, JuliacException {
        String target;
        String source;
        String classDirName;
        String genDirName;
        String s;
        if (args.length == 0) {
            Juliac.usage();
            return;
        }
        CmdLineArgs<CmdLineFlags, CmdLineOptions> cla = new CmdLineArgs<CmdLineFlags, CmdLineOptions>();
        cla.registerOption(CmdLineOptions.OPT);
        cla.registerOption(CmdLineOptions.IGS);
        cla.registerOption(CmdLineOptions.SRCS);
        cla.registerOption(CmdLineOptions.MIXINS);
        cla.registerOption(CmdLineOptions.PKGROOT);
        cla.registerOption(CmdLineOptions.GENSRC);
        cla.registerOption(CmdLineOptions.GENCLASS);
        cla.registerOption(CmdLineOptions.SOURCE, JDKLevel.getVersions());
        cla.registerOption(CmdLineOptions.TARGET, JDKLevel.getVersions());
        cla.registerOption(CmdLineOptions.COMPILER);
        cla.registerFlag(CmdLineFlags.COMPILEINPUT);
        cla.registerFlag(CmdLineFlags.COMPILEGENERATED);
        cla.registerFlag(CmdLineFlags.DEBUG);
        Juliac jc = new Juliac();
        JuliacConfig jconf = new JuliacConfig(jc);
        jc.setJuliacConfig(jconf);
        try {
            cla.parse(args);
        }
        catch (IllegalArgumentException iae) {
            String msg = iae.getMessage();
            Juliac.reportError(msg);
            return;
        }
        String opt = cla.getOptionValue(CmdLineOptions.OPT);
        if (opt == null) {
            OptLevel level = OptLevel.getDefaultOptLevel();
            opt = level.toString();
        }
        jconf.setOptLevel(opt);
        jconf.loadOptLevels();
        String igs = cla.getOptionValue(CmdLineOptions.IGS);
        if (igs != null) {
            jconf.setInterceptorSourceCodeGenerators(igs);
        }
        jconf.loadInterceptorSourceCodeGenerators();
        String compiler = cla.getOptionValue(CmdLineOptions.COMPILER);
        if (compiler != null) {
            jconf.setCompiler(compiler);
        }
        String[] srcs = (s = cla.getOptionValue(CmdLineOptions.SRCS)) == null ? new String[]{} : s.split(";");
        jconf.addSrcs(srcs);
        s = cla.getOptionValue(CmdLineOptions.MIXINS);
        String[] srclibs = s == null ? new String[]{} : s.split(";");
        jconf.addSrclibs(srclibs);
        String pkgRoot = cla.getOptionValue(CmdLineOptions.PKGROOT);
        if (pkgRoot != null) {
            jconf.setPkgRoot(pkgRoot);
        }
        if ((genDirName = cla.getOptionValue(CmdLineOptions.GENSRC)) != null) {
            jconf.setGenDirName(genDirName);
        }
        if ((classDirName = cla.getOptionValue(CmdLineOptions.GENCLASS)) != null) {
            jconf.setClassDirName(classDirName);
        }
        if ((source = cla.getOptionValue(CmdLineOptions.SOURCE)) != null) {
            jconf.setSourceLevel(source);
        }
        if ((target = cla.getOptionValue(CmdLineOptions.TARGET)) != null) {
            jconf.setTargetLevel(target);
        }
        List<String> files = cla.getFiles();
        boolean debug = cla.isFlagSet(CmdLineFlags.DEBUG);
        if (debug) {
            Juliac.reportInfo("Juliac classpath:");
            ClassLoader cl = Juliac.class.getClassLoader();
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader urlcl = (URLClassLoader)cl;
                for (URL url : urls = urlcl.getURLs()) {
                    Juliac.reportInfo("  " + url);
                }
            } else {
                Juliac.reportWarning("Class loader for the Juliac class is not a URLClassLoader");
            }
            Juliac.reportInfo("-----------------");
        }
        if (cla.isFlagSet(CmdLineFlags.COMPILEINPUT)) {
            jc.compileAndReport(debug);
        }
        for (String file : files) {
            Juliac.reportInfo(file + "...");
            try {
                jc.generate(file, file);
            }
            catch (IllegalArgumentException iae) {
                try {
                    jc.generate(file);
                }
                catch (IllegalArgumentException iae2) {
                    System.err.println("---- Stack trace 1 ----");
                    iae.printStackTrace();
                    System.err.println("---- Stack trace 2 ----");
                    iae2.printStackTrace();
                    String msg = file + " is neither an ADL descriptor, " + "nor a membrane descriptor";
                    Juliac.reportError(msg);
                    return;
                }
            }
        }
        if (cla.isFlagSet(CmdLineFlags.COMPILEGENERATED)) {
            jc.compileAndReport(debug);
        }
        jc.close();
        Juliac.reportInfo("Done.");
    }

    private static void usage() {
        Juliac.reportInfo("java " + Juliac.class.getName() + " [options] types");
        Juliac.reportInfo("Generate the Java source code associated with the specified ADL types or membrane descriptors");
        Juliac.reportInfo("");
        Juliac.reportInfo("Options:");
        Juliac.reportInfo("  --srcs <dirs>      : source directories (default: src/main/java)");
        Juliac.reportInfo("  --source <version> : the Java source code compatibility level (default: 1.5)");
        Juliac.reportInfo("  --target <version> : the Java bytecode compatibility level (default: 1.5)");
        Juliac.reportInfo("  --mixins <dirs>    : mixin layer directories");
        Juliac.reportInfo("  --opt <level>      : optimization level (default: OO)");
        Juliac.reportInfo("  --igs <generators> : interceptor source code generators");
        Juliac.reportInfo("  --compiler <comp>  : Java compiler (default: JDT)");
        Juliac.reportInfo("  --compileInput     : compile input code");
        Juliac.reportInfo("  --compileGenerated : compile generated code");
        Juliac.reportInfo("  --pkgRoot <name>   : root package for generated code (default: 'none')");
        Juliac.reportInfo("  --gensrc <dir>     : directory for generated source code");
        Juliac.reportInfo("                       (default: target/generated-sources/juliac)");
        Juliac.reportInfo("  --genclass <dir>   : directory for compiled code (default: target/classes)");
        Juliac.reportInfo("");
        Juliac.reportInfo("Details:");
        Juliac.reportInfo("  <dirs> is a semicolon-separated list of directories");
        Juliac.reportInfo("  <level> is:");
        Juliac.reportInfo("    - either one of the predefined values:");
        Juliac.reportInfo("      OO, MERGE_ALL, COMP, ULTRA_COMP or ULTRA_MERGE");
        Juliac.reportInfo("    - or a custom value: the fully-qualified name of a class");
        Juliac.reportInfo("      which implements FCSourceCodeGeneratorItf");
        Juliac.reportInfo("    - or a colon-separated list of predefined or custom values");
        Juliac.reportInfo("      e.g. OO:COMP");
        Juliac.reportInfo("        - a chain of responsibility pattern is applied on the specified");
        Juliac.reportInfo("          optimization level source code generators");
        Juliac.reportInfo("    - or a colon-separated list of pairs prefix=value");
        Juliac.reportInfo("      e.g. /julia/=OO:/koch/=COMP");
        Juliac.reportInfo("        - prefix is the name prefix to be appended in front of controller descriptors");
        Juliac.reportInfo("          descriptors. The first prefix is considered to be the default one.");
        Juliac.reportInfo("        - value is either predefined or custom");
        Juliac.reportInfo("  <generators> is a colon-separated list of pairs asmgen=srcgen");
        Juliac.reportInfo("    - asmgen is the fqname of the ASM bytecode generator");
        Juliac.reportInfo("    - srcgen is the fqname of the corresponding source code generator");
        Juliac.reportInfo("      e.g. org.objectweb.fractal.julia.asm.LifeCycleCodeGenerator=");
        Juliac.reportInfo("             org.objectweb.fractal.juliac.proxy.LifeCycleSourceCodeGenerator");
        Juliac.reportInfo("  <comp> is:");
        Juliac.reportInfo("    - either one of the predefined values: JDT or JDK6");
        Juliac.reportInfo("    - or a custom value: the fully-qualified name of a class");
        Juliac.reportInfo("      which implements CompileSupportItf");
    }

    public Juliac() {
        UClassFactory ucf = new UClassFactory(this);
        this.register(ucf);
    }

    public JuliacConfig getJuliacConfig() throws IllegalArgumentException {
        if (this.jconf == null) {
            String msg = "JuliacConfig (jconf) has not been set for this instance of Juliac: " + this;
            throw new IllegalArgumentException(msg);
        }
        return this.jconf;
    }

    public void setJuliacConfig(JuliacConfig jconf) {
        this.jconf = jconf;
    }

    public void close() throws IOException, JuliacException {
        JuliacConfig jconf = this.getJuliacConfig();
        jconf.close();
        if (this.compiler != null) {
            this.compiler.close();
        }
    }

    public static void reportInfo(String msg) {
        Logger logger = Juliac.getLogger();
        logger.info(msg);
    }

    public static void reportWarning(String msg) {
        Logger logger = Juliac.getLogger();
        logger.warning(msg);
    }

    public static void reportError(String msg) {
        Logger logger = Juliac.getLogger();
        logger.severe(msg);
    }

    public static Logger getLogger() {
        if (logger == null) {
            Handler[] handlers;
            logger = Logger.getLogger(LOGGER_NAME);
            Logger parent = logger.getParent();
            for (Handler handler : handlers = parent.getHandlers()) {
                JuliacLoggerFormatter newFormatter = new JuliacLoggerFormatter();
                handler.setFormatter(newFormatter);
            }
        }
        return logger;
    }

    public FCSourceCodeGeneratorItf<?> getFCSourceCodeGenerator(String adl) throws IllegalArgumentException {
        JuliacConfig jconf = this.getJuliacConfig();
        List<FCSourceCodeGeneratorItf<?>> fcscgs = jconf.getOptLevelSourceCodeGenerators(null);
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            boolean accept = fcscg.acceptADLDesc(adl);
            if (!accept) continue;
            return fcscg;
        }
        String msg = "No source code generator for ADL descriptor: " + adl;
        throw new IllegalArgumentException(msg);
    }

    public FCSourceCodeGeneratorItf<?> getFCSourceCodeGenerator(Type type, Object controllerDesc, Object contentDesc) throws IllegalArgumentException {
        JuliacConfig jconf = this.getJuliacConfig();
        String ctrlDesc = (String)controllerDesc;
        List<FCSourceCodeGeneratorItf<?>> fcscgs = jconf.getOptLevelSourceCodeGenerators(ctrlDesc);
        ctrlDesc = Utils.stripControllerDescPrefix(ctrlDesc);
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            boolean accept = fcscg.acceptCtrlDesc(ctrlDesc);
            if (!accept) continue;
            return fcscg;
        }
        String msg = "No source code generator for controller descriptor: " + controllerDesc;
        throw new IllegalArgumentException(msg);
    }

    public void generate(String adl, String targetname) throws IOException, IllegalArgumentException {
        FCSourceCodeGeneratorItf<?> fcscg = this.getFCSourceCodeGenerator(adl);
        String rootedName = this.getRootedClassName(targetname);
        fcscg.generate(adl, rootedName);
    }

    public FCSourceCodeGeneratorItf<?> generate(Object controllerDesc) throws IOException, InstantiationException, IllegalArgumentException {
        String ctrlDesc = (String)controllerDesc;
        BasicComponentType ct = new BasicComponentType((InterfaceType[])new BasicInterfaceType[0]);
        FCSourceCodeGeneratorItf<?> fcscg = this.getFCSourceCodeGenerator((Type)ct, ctrlDesc, null);
        fcscg.generateMembraneImpl((ComponentType)ct, ctrlDesc, null);
        return fcscg;
    }

    public void generateSourceCode(ClassGeneratorItf scg) throws IOException {
        String targetClassName = scg.getTargetClassName();
        ClassLoader classLoader = this.getJuliacConfig().getClassLoader();
        try {
            classLoader.loadClass(targetClassName);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.generateSourceCodeOverride(scg);
            return;
        }
    }

    public void generateSourceCodeOverride(ClassGeneratorItf scg) throws IOException {
        SourceFile sf;
        JuliacConfig jconf = this.getJuliacConfig();
        File genDir = jconf.getGenDir();
        String targetClassName = scg.getTargetClassName();
        CompilationRounds rounds = this.getJuliacConfig().getCompilationRounds();
        if (rounds.contains(sf = SourceFile.create(genDir, targetClassName))) {
            return;
        }
        String filename = targetClassName.replace('.', File.separatorChar) + ".java";
        File f = new File(genDir, filename);
        File fdir = f.getParentFile();
        fdir.mkdirs();
        FileWriter fw = new FileWriter(f);
        PrintWriter pw = new PrintWriter(fw);
        FileSourceCodeWriter cw = new FileSourceCodeWriter(pw);
        scg.generate(cw);
        pw.close();
        fw.close();
        CompilationRound round = rounds.getCurrentCompilationRound();
        round.addGenerated(SourceFile.create(genDir, targetClassName));
    }

    public boolean hasBeenGenerated(String name) throws IOException {
        SourceFile igf;
        JuliacConfig jconf = this.getJuliacConfig();
        File genDir = jconf.getGenDir();
        CompilationRounds rounds = jconf.getCompilationRounds();
        if (rounds.contains(igf = SourceFile.create(genDir, name))) {
            return true;
        }
        ClassLoader classLoader = jconf.getClassLoader();
        try {
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public void compileAndReport(boolean debug) throws IOException {
        Juliac.reportInfo("Compiling...");
        CompilationRound round = this.compile();
        List<SourceFile> inputFiles = round.getInputFiles();
        List<SourceFile> generatedFiles = round.getGeneratedFiles();
        if (debug) {
            for (SourceFile isf : inputFiles) {
                Juliac.reportInfo("   " + isf.getQname());
            }
            for (SourceFile igf : generatedFiles) {
                Juliac.reportInfo("   " + igf.getQname());
            }
        }
        int total = inputFiles.size() + generatedFiles.size();
        String msg = total + " file(s) compiled to " + round.getClassDir().getAbsolutePath();
        Juliac.reportInfo(msg);
    }

    public CompilationRound compile() throws IOException {
        JuliacConfig jconf = this.getJuliacConfig();
        CompilationRounds rounds = jconf.getCompilationRounds();
        CompilationRound round = rounds.getCurrentCompilationRound();
        List<SourceFile> inputFiles = round.getInputFiles();
        List<SourceFile> generatedFiles = round.getGeneratedFiles();
        if (inputFiles.size() == 0 && generatedFiles.size() == 0) {
            Juliac.reportInfo("No file to compile");
            return round;
        }
        CompileSupportItf compiler = this.getCompiler();
        round.compile(compiler);
        return round;
    }

    public String getRootedClassName(String contentClassName) {
        JuliacConfig jconf = this.getJuliacConfig();
        String pkgRoot = jconf.getPkgRoot();
        if (pkgRoot != null && pkgRoot.length() != 0) {
            StringBuffer rootedClassName = new StringBuffer();
            rootedClassName.append(pkgRoot);
            rootedClassName.append('.');
            rootedClassName.append(contentClassName);
            return rootedClassName.toString();
        }
        return contentClassName;
    }

    public CompileSupportItf getCompiler() throws JuliacRuntimeException {
        if (this.compiler == null) {
            String cnfeMessage;
            JuliacConfig jconf = this.getJuliacConfig();
            Compiler compiler = jconf.getCompiler();
            String compilerClassName = compiler.getClassName();
            Object o = this.loadAndInstantiate(compilerClassName, cnfeMessage = "Compile support class can not be found: " + (Object)((Object)compiler));
            if (!(o instanceof CompileSupportItf)) {
                String msg = "Compile support class " + (Object)((Object)compiler) + " should implement CompileSupportItf";
                throw new JuliacRuntimeException(msg);
            }
            this.compiler = (CompileSupportItf)o;
            this.compiler.init(this);
        }
        return this.compiler;
    }

    public ADLParserSupportItf getFractalADL() {
        if (this.fractaladl == null) {
            String cnfeMessage = "Fractal ADL support class implementation can not be found: org.objectweb.fractal.juliac.adl.FractalADLSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-fractaladl artifact is included in the project dependencies.";
            this.fractaladl = (ADLParserSupportItf)this.loadAndInstantiate("org.objectweb.fractal.juliac.adl.FractalADLSupportImpl", "Fractal ADL support class implementation can not be found: org.objectweb.fractal.juliac.adl.FractalADLSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-fractaladl artifact is included in the project dependencies.");
            this.fractaladl.init(this);
        }
        return this.fractaladl;
    }

    public SpoonSupportItf getSpoon() throws JuliacRuntimeException {
        if (this.spoon == null) {
            String cnfeMessage = "Spoon support class implementation can not be found: org.objectweb.fractal.juliac.spoon.SpoonSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-spoon artifact is included in the project dependencies.";
            this.spoon = (SpoonSupportItf)this.loadAndInstantiate("org.objectweb.fractal.juliac.spoon.SpoonSupportImpl", "Spoon support class implementation can not be found: org.objectweb.fractal.juliac.spoon.SpoonSupportImpl. Check that the org.objectweb.fractal.juliac:juliac-spoon artifact is included in the project dependencies.");
            try {
                this.spoon.init(this);
            }
            catch (IOException e) {
                throw new JuliacRuntimeException(e);
            }
        }
        return this.spoon;
    }

    private <T> T loadAndInstantiate(String clname, String cnfeMessage) throws JuliacRuntimeException {
        JuliacConfig jconf = this.getJuliacConfig();
        Class cl = null;
        try {
            cl = jconf.load(clname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JuliacRuntimeException(cnfeMessage, cnfe);
        }
        Object service = jconf.instantiate(cl);
        return service;
    }

    public void register(UnifiedClassFactoryItf ucf) {
        this.ucfs.add(ucf);
    }

    public UnifiedClass create(String name) throws JuliacRuntimeException {
        for (UnifiedClassFactoryItf ucf : this.ucfs) {
            try {
                UnifiedClass uc = ucf.create(name);
                return uc;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new JuliacRuntimeException(new ClassNotFoundException(name));
    }

    public String getInterfaceTypeSignature(InterfaceType it) {
        String signature = it.getFcItfSignature();
        UnifiedClass proxycl = this.create(it.getFcItfSignature());
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length == 0) {
            return signature;
        }
        StringBuffer sb = new StringBuffer(signature);
        String s = Utils.getTypeParameterNamesSignature(tpnames);
        sb.append(s);
        return sb.toString();
    }
}

