/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.JuliaLoader;
import org.objectweb.fractal.juliac.desc.ControllerDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuliacLoader
extends JuliaLoader {
    public JuliacLoader(ClassLoader classloader) {
        super(classloader);
    }

    public InterfaceType[] getMembraneType(String ctrlDesc, Map<?, ?> context) {
        Tree t = this.loadTree(ctrlDesc);
        Tree tree = this.evalTree(t, context);
        Tree membraneItfTree = tree.getSubTree(1);
        Tree[] ctrlItfTrees = membraneItfTree.getSubTrees();
        InterfaceType[] its = new InterfaceType[ctrlItfTrees.length];
        for (int i = 0; i < its.length; ++i) {
            String name = ctrlItfTrees[i].getSubTree(0).toString();
            String signature = ctrlItfTrees[i].getSubTree(1).toString();
            its[i] = new BasicInterfaceType(name, signature, false, false, false);
        }
        return its;
    }

    public List<String> getMembraneImplLayers(String ctrlDesc, Map<?, ?> context) {
        Tree[] ctrlTrees = this.getCtrlImplTrees(ctrlDesc, context);
        ArrayList<String> layers = new ArrayList<String>();
        for (Tree ctrlTree : ctrlTrees) {
            if (ctrlTree.getSize() == 0) {
                String name = ctrlTree.toString();
                JuliacLoader.layerInsert(layers, name);
                continue;
            }
            Tree t = ctrlTree.getSubTree(0);
            Tree[] ts = t.getSubTrees();
            for (int i = 2; i < ts.length; ++i) {
                String name = ts[i].toString();
                JuliacLoader.layerInsert(layers, name);
            }
        }
        return layers;
    }

    public List<ControllerDesc> getCtrlsImplLayers(String ctrldesc, Map<?, ?> context) {
        Tree[] ctrlTrees = this.getCtrlImplTrees(ctrldesc, context);
        ArrayList<ControllerDesc> ctrlDescs = new ArrayList<ControllerDesc>();
        for (int i = 0; i < ctrlTrees.length; ++i) {
            Tree ctrlTree = ctrlTrees[i];
            ControllerDesc ctrlDesc = null;
            if (ctrlTree.getSize() == 0) {
                String name = ctrlTree.toString();
                ctrlDesc = new ControllerDesc(name, null, null);
            } else {
                Tree t = ctrlTree.getSubTree(0);
                Tree[] ts = t.getSubTrees();
                String name = ts[1].toString();
                ArrayList<String> layers = new ArrayList<String>();
                for (int j = 2; j < ts.length; ++j) {
                    String s = ts[j].toString();
                    JuliacLoader.layerInsert(layers, s);
                }
                ctrlDesc = new ControllerDesc(name, layers, ctrlTree);
            }
            ctrlDescs.add(ctrlDesc);
        }
        return ctrlDescs;
    }

    public Tree[] getCtrlImplTrees(String ctrlDesc, Map<?, ?> context) {
        Tree t = this.loadTree(ctrlDesc);
        Tree tree = this.evalTree(t, context);
        Tree membraneTree = tree.getSubTree(2);
        Tree[] ctrlTrees = membraneTree.getSubTrees();
        return ctrlTrees;
    }

    public String[] getInterceptorCodeGenerator(String ctrlDesc, Map<?, ?> context) {
        Tree t = this.loadTree(ctrlDesc);
        Tree tree = this.evalTree(t, context);
        Tree interceptTree = tree.getSubTree(3);
        if (interceptTree.getSize() == 0) {
            return null;
        }
        Tree t0 = interceptTree.getSubTree(0);
        String[] names = new String[t0.getSize() - 1];
        for (int i = 0; i < names.length; ++i) {
            Tree tt = t0.getSubTree(i + 1);
            names[i] = tt.toString();
        }
        return names;
    }

    private static void layerInsert(List<String> layers, String name) {
        if (layers.contains(name)) {
            layers.remove(name);
        }
        layers.add(name);
    }
}

