/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.conf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.juliac.CompilationRound;
import org.objectweb.fractal.juliac.CompilationRounds;
import org.objectweb.fractal.juliac.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacException;
import org.objectweb.fractal.juliac.JuliacLoader;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.conf.Compiler;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.OptLevel;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuliacConfig {
    private Juliac jc;
    private File baseDir = new File(".");
    private List<String> srcs = new ArrayList<String>();
    private List<String> srclibs = new ArrayList<String>();
    private String pkgRoot = "";
    private String genDirName = "target/generated-sources/juliac";
    private File genDir;
    private String classDirName = "target/classes";
    private File classDir;
    private JDKLevel sourceLevel = JDKLevel.getDefaultSourceLevel();
    private JDKLevel targetLevel = JDKLevel.getDefaultTargetLevel();
    private Compiler compiler = Compiler.getDefaultCompiler();
    private List<String> optLevelPrefixes = new ArrayList<String>();
    private List<String> optLevelNames = new ArrayList<String>();
    private Map<String, FCSourceCodeGeneratorItf<?>> optLevels = new HashMap();
    private Map<String, String> iscgNames = new HashMap<String, String>();
    private Map<String, InterceptorSourceCodeGenerator> iscgs = new HashMap<String, InterceptorSourceCodeGenerator>();
    private ClassLoader classLoader;
    private JuliacLoader loader;
    private CompilationRounds rounds;

    public JuliacConfig(Juliac jc) {
        this.jc = jc;
    }

    public void close() throws IOException, JuliacException {
        Collection<FCSourceCodeGeneratorItf<?>> fcscgs = this.optLevels.values();
        for (FCSourceCodeGeneratorItf<?> fcscg : fcscgs) {
            fcscg.close();
        }
    }

    public void setPkgRoot(String pkgRoot) {
        this.pkgRoot = pkgRoot;
    }

    public String getPkgRoot() {
        return this.pkgRoot;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String[] getSrcs() {
        return this.srcs.toArray(new String[this.srcs.size()]);
    }

    public void addSrc(String src) throws IOException {
        File baseDir = this.getBaseDir();
        ArrayList<SourceFile> sfs = new ArrayList<SourceFile>();
        SourceFile.addAllJavaFiles(baseDir, src, sfs);
        CompilationRounds rounds = this.getCompilationRounds();
        CompilationRound round = rounds.getCurrentCompilationRound();
        round.addInput(sfs);
        this.srcs.add(src);
    }

    public void addSrcs(String[] srcs) throws IOException {
        for (String src : srcs) {
            this.addSrc(src);
        }
    }

    public String[] getSrclibs() {
        return this.srclibs.toArray(new String[this.srclibs.size()]);
    }

    public void addSrclib(String srclib) {
        this.srclibs.add(srclib);
    }

    public void addSrclibs(String[] srclibs) {
        for (String srclib : srclibs) {
            this.addSrclib(srclib);
        }
    }

    public File getGenDir() throws IOException {
        if (this.genDir == null) {
            File baseDir = this.getBaseDir();
            String genDirName = this.getGenDirName();
            this.genDir = JuliacConfig.initDir(baseDir, genDirName);
        }
        return this.genDir;
    }

    public String getGenDirName() {
        return this.genDirName;
    }

    public void setGenDirName(String genDirName) throws IOException {
        File baseDir = this.getBaseDir();
        this.genDir = JuliacConfig.initDir(baseDir, genDirName);
    }

    public File getClassDir() throws IOException {
        if (this.classDir == null) {
            File baseDir = this.getBaseDir();
            String classDirName = this.getClassDirName();
            this.classDir = JuliacConfig.initDir(baseDir, classDirName);
        }
        return this.classDir;
    }

    public String getClassDirName() {
        return this.classDirName;
    }

    public void setClassDirName(String classDirName) throws IOException {
        File baseDir = this.getBaseDir();
        this.classDir = JuliacConfig.initDir(baseDir, classDirName);
    }

    public JDKLevel getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String source) {
        this.sourceLevel = JDKLevel.valueOfIAE(source);
    }

    public void setSourceLevel(JDKLevel sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public JDKLevel getTargetLevel() {
        return this.targetLevel;
    }

    public void setTargetLevel(String target) {
        this.targetLevel = JDKLevel.valueOfIAE(target);
    }

    public void setTargetLevel(JDKLevel targetLevel) {
        this.targetLevel = targetLevel;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        try {
            this.compiler = Compiler.valueOf(compiler);
        }
        catch (IllegalArgumentException iae) {
            this.compiler = Compiler.CUSTOM;
            this.compiler.setClassName(compiler);
        }
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setOptLevel(String optLevel) throws IllegalArgumentException {
        this.optLevelPrefixes = new ArrayList<String>();
        this.optLevelNames = new ArrayList<String>();
        String[] levels = optLevel.split(":");
        for (int i = 0; i < levels.length; ++i) {
            String name;
            String[] elts = levels[i].split("=");
            if (elts.length > 2) {
                String msg = "Too many = in " + levels[i];
                throw new IllegalArgumentException(msg);
            }
            String prefix = elts.length == 1 ? null : elts[0];
            String string = name = elts.length == 1 ? elts[0] : elts[1];
            if (i == 0 && prefix != null) {
                this.addOptLevel(null, name);
            }
            this.addOptLevel(prefix, name);
        }
    }

    public void loadOptLevels() throws ClassNotFoundException, IOException {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.optLevelNames);
        for (String optLevelName : copy) {
            Class cl = this.load(optLevelName);
            FCSourceCodeGeneratorItf fcscg = (FCSourceCodeGeneratorItf)this.instantiate(cl);
            fcscg.init(this.jc);
            this.optLevels.put(optLevelName, fcscg);
        }
    }

    public void addOptLevel(String prefix, String optLevelName) {
        String clname = null;
        try {
            OptLevel level = OptLevel.valueOf(optLevelName);
            clname = level.getClassName();
        }
        catch (IllegalArgumentException iae) {
            clname = optLevelName;
        }
        this.optLevelPrefixes.add(prefix);
        this.optLevelNames.add(clname);
    }

    public void addOptLevel(String prefix, FCSourceCodeGeneratorItf<?> fcscg) {
        String clname = fcscg.getClass().getName();
        this.optLevelPrefixes.add(prefix);
        this.optLevelNames.add(clname);
        this.optLevels.put(clname, fcscg);
    }

    public List<FCSourceCodeGeneratorItf<?>> getOptLevelSourceCodeGenerators(String ctrlDesc) throws IllegalArgumentException {
        if (this.optLevelNames.size() == 0) {
            String msg = "No default optimization level source code generator";
            throw new IllegalArgumentException(msg);
        }
        String prefix = ctrlDesc == null ? null : Utils.getControllerDescPrefix(ctrlDesc);
        ArrayList scgs = new ArrayList();
        for (int i = 0; i < this.optLevelPrefixes.size(); ++i) {
            String p = this.optLevelPrefixes.get(i);
            String name = this.optLevelNames.get(i);
            FCSourceCodeGeneratorItf<?> scg = this.optLevels.get(name);
            if (scg == null) {
                String msg = "Source code generator for " + ctrlDesc + "is null. Check that loadOptLevels() has been invoked.";
                throw new IllegalArgumentException(msg);
            }
            if (ctrlDesc == null) {
                scgs.add(scg);
                continue;
            }
            if (prefix == null) {
                if (p != null) continue;
                scgs.add(scg);
                continue;
            }
            if (!prefix.equals(p)) continue;
            scgs.add(scg);
        }
        if (scgs.size() == 0) {
            String msg = "No source code generator for " + ctrlDesc;
            throw new IllegalArgumentException(msg);
        }
        return scgs;
    }

    public List<String> getArtifactIdsForKnownOptLevels() {
        Map<String, String> map = OptLevel.toMap();
        ArrayList<String> ols = new ArrayList<String>();
        for (String name : this.optLevelNames) {
            if (!map.containsKey(name)) continue;
            String artifactId = map.get(name);
            ols.add(artifactId);
        }
        return ols;
    }

    public void setInterceptorSourceCodeGenerators(String def) throws IllegalArgumentException {
        String[] iscgs;
        for (String iscg : iscgs = def.split(":")) {
            String[] elts = iscg.split("=");
            if (elts.length != 2) {
                String msg = iscg + " should contain only one =";
                throw new IllegalArgumentException(msg);
            }
            String asm = elts[0];
            String scg = elts[1];
            this.putInterceptorSourceCodeGenerator(asm, scg);
        }
    }

    public void putInterceptorSourceCodeGenerator(String key, String iscgName) {
        this.iscgNames.put(key, iscgName);
    }

    public void putInterceptorSourceCodeGenerator(String key, InterceptorSourceCodeGenerator iscg) {
        this.iscgs.put(key, iscg);
    }

    public void loadInterceptorSourceCodeGenerators() throws ClassNotFoundException {
        for (Map.Entry<String, String> entry : this.iscgNames.entrySet()) {
            String key = entry.getKey();
            String name = entry.getValue();
            Class cl = this.load(name);
            InterceptorSourceCodeGenerator iscg = (InterceptorSourceCodeGenerator)this.instantiate(cl);
            this.iscgs.put(key, iscg);
        }
    }

    public boolean containsInterceptorSourceCodeGenerator(String key) {
        return this.iscgs.containsKey(key);
    }

    public InterceptorSourceCodeGenerator getInterceptorSourceCodeGenerator(String key) {
        InterceptorSourceCodeGenerator iscg = this.iscgs.get(key);
        return iscg;
    }

    public CompilationRounds getCompilationRounds() {
        if (this.rounds == null) {
            this.rounds = new CompilationRounds(this);
        }
        return this.rounds;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JuliacLoader getJuliacLoader() {
        if (this.loader == null) {
            ClassLoader classloader = this.getClassLoader();
            this.loader = new JuliacLoader(classloader);
        }
        return this.loader;
    }

    public <T> Class<T> load(String name) throws ClassNotFoundException {
        Class<?> c;
        ClassLoader classloader = this.getClassLoader();
        Class<?> cl = c = classloader.loadClass(name);
        return cl;
    }

    public <T> T instantiate(Class<T> cl) throws JuliacRuntimeException {
        try {
            T o = cl.newInstance();
            return o;
        }
        catch (InstantiationException e) {
            throw new JuliacRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JuliacRuntimeException(e);
        }
    }

    public List<String> getClassPathEntries() {
        ArrayList<String> lst = new ArrayList<String>();
        ClassLoader classLoader = this.getClassLoader();
        while (classLoader != null && classLoader instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader urlcl = (URLClassLoader)classLoader;
            for (URL url : urls = urlcl.getURLs()) {
                String absfilename = url.getPath();
                File f = new File(absfilename = absfilename.replace("%20", " "));
                boolean isRegular = Utils.isRegularClassPathEntry(f);
                if (!isRegular) continue;
                lst.add(absfilename);
            }
            classLoader = urlcl.getParent();
        }
        return lst;
    }

    private static File initDir(File baseDir, String dirName) throws IOException {
        File dir = Utils.getFile(baseDir, dirName);
        if (dir.exists() && !dir.isDirectory()) {
            String msg = dir.getAbsolutePath() + " is not a directory";
            throw new IOException(msg);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

