/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.desc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.juliac.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.InitializerClassGenerator;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.desc.AttributeDesc;
import org.objectweb.fractal.juliac.desc.BindingDesc;
import org.objectweb.fractal.juliac.desc.BindingType;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDesc {
    private String id;
    private String name;
    private String definition;
    private FCSourceCodeGeneratorItf<?> fcscg;
    private ComponentType ct;
    private String ctrlDesc;
    private String contentClassName;
    private Map<String, AttributeDesc> attributes = new HashMap<String, AttributeDesc>();
    private List<AttributeDesc> lattributes = new ArrayList<AttributeDesc>();
    private Map<String, BindingDesc> bindings = new HashMap<String, BindingDesc>();
    private List<BindingDesc> lbindings = new ArrayList<BindingDesc>();
    private List<ComponentDesc> superComponents = new ArrayList<ComponentDesc>();
    private List<ComponentDesc> subComponents = new ArrayList<ComponentDesc>();

    public ComponentDesc(String id, String name, String definition, FCSourceCodeGeneratorItf<?> fcscg, ComponentType ct, String ctrlDesc, String contentClassName) {
        this.id = id;
        this.name = name;
        this.definition = definition;
        this.fcscg = fcscg;
        this.ct = ct;
        this.ctrlDesc = ctrlDesc;
        this.contentClassName = contentClassName;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public FCSourceCodeGeneratorItf<?> getFCSourceCodeGenerator() {
        return this.fcscg;
    }

    public ComponentType getCT() {
        return this.ct;
    }

    public String getCtrlDesc() {
        return this.ctrlDesc;
    }

    public String getContentClassName() {
        return this.contentClassName;
    }

    public String toString() {
        return this.id;
    }

    public void addInterfaceTypes(InterfaceType[] its) throws InstantiationException {
        InterfaceType[] currentits = this.ct.getFcInterfaceTypes();
        InterfaceType[] newits = new InterfaceType[currentits.length + its.length];
        System.arraycopy(currentits, 0, newits, 0, currentits.length);
        System.arraycopy(its, 0, newits, currentits.length, its.length);
        this.ct = new BasicComponentType(newits);
    }

    public void addAttribute(String name, AttributeDesc adesc) {
        this.attributes.put(name, adesc);
        this.lattributes.add(adesc);
    }

    public AttributeDesc getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public void addBinding(String cltItfName, BindingDesc bdesc) throws IllegalArgumentException {
        String bdescCltItfName = bdesc.getCltItfName();
        if (!cltItfName.equals(bdescCltItfName)) {
            String msg = "cltItfName (" + cltItfName + ") and the value returned by bdesc.getCltItfName (" + bdescCltItfName + ") differ";
            throw new IllegalArgumentException(msg);
        }
        this.bindings.put(cltItfName, bdesc);
        this.lbindings.add(bdesc);
    }

    public BindingDesc getBinding(String cltIftName) {
        BindingDesc bdesc = this.bindings.get(cltIftName);
        return bdesc;
    }

    public Set<String> getBindingCltItfNames() {
        return this.bindings.keySet();
    }

    public List<BindingDesc> getBindingDescs() {
        return this.lbindings;
    }

    public ComponentDesc getBoundComponent(String name) {
        BindingDesc bdesc = this.bindings.get(name);
        if (bdesc == null) {
            return null;
        }
        ComponentDesc cdesc = bdesc.getSrv();
        return cdesc;
    }

    public ComponentDesc getBoundPrimitiveComponent(String name) {
        BindingDesc bdesc = this.bindings.get(name);
        if (bdesc == null) {
            return null;
        }
        String srvItfName = bdesc.getSrvItfName();
        ComponentDesc srv = bdesc.getSrv();
        String srvCtrlDesc = srv.getCtrlDesc();
        if (srvCtrlDesc.equals("primitive")) {
            return srv;
        }
        ComponentDesc bound = srv.getBoundPrimitiveComponent(srvItfName);
        return bound;
    }

    public List<String> getBoundContentClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ComponentDesc> visited = new ArrayList<ComponentDesc>();
        this.getBoundContentClassNames(names, visited);
        return names;
    }

    private void getBoundContentClassNames(List<String> names, List<ComponentDesc> visited) {
        if (!visited.contains(this)) {
            visited.add(this);
            if (this.contentClassName != null) {
                names.add(this.contentClassName);
            }
            Collection<BindingDesc> bdescs = this.bindings.values();
            for (BindingDesc bdesc : bdescs) {
                ComponentDesc srv = bdesc.getSrv();
                srv.getBoundContentClassNames(names, visited);
            }
        }
    }

    public void addSuperComponent(ComponentDesc parent) {
        this.superComponents.add(parent);
    }

    public void addSubComponent(ComponentDesc sub) {
        this.subComponents.add(sub);
    }

    public List<ComponentDesc> getSuperComponents() {
        return this.superComponents;
    }

    public List<ComponentDesc> getSubComponents() {
        return this.subComponents;
    }

    public void generate(PrintWriter pw, boolean declareLocalVars) {
        this.generateInstantiations(pw, declareLocalVars);
        this.generateHierarchy(pw);
        this.generateBindings(pw);
    }

    protected void generateInstantiations(PrintWriter pw, boolean declareLocalVars) {
        InitializerClassGenerator<?> cg = null;
        try {
            cg = this.fcscg.generate((Type)this.ct, this.ctrlDesc, this.contentClassName);
        }
        catch (IOException e) {
            throw new JuliacRuntimeException(e);
        }
        String initializerClassName = cg.getTargetClassName();
        if (declareLocalVars) {
            pw.print(Component.class.getName());
            pw.print(" ");
        }
        pw.print(this.id);
        pw.print(" = new ");
        pw.print(initializerClassName);
        pw.println("().newFcInstance();");
        this.generateComponentName(pw);
        this.generateAttributes(pw);
        for (ComponentDesc sub : this.subComponents) {
            sub.generateInstantiations(pw, declareLocalVars);
        }
    }

    protected void generateComponentName(PrintWriter pw) {
        pw.print(Fractal.class.getName());
        pw.print(".getNameController(");
        pw.print(this.id);
        pw.print(").setFcName(\"");
        pw.print(this.name);
        pw.println("\");");
    }

    protected void generateAttributes(PrintWriter pw) {
        for (Map.Entry<String, AttributeDesc> attribute : this.attributes.entrySet()) {
            String name = attribute.getKey();
            AttributeDesc adesc = attribute.getValue();
            String attributeController = adesc.getAttributeController();
            String mname = name.substring(0, 1).toUpperCase() + name.substring(1);
            String value = adesc.getValue();
            pw.print("((");
            pw.print(attributeController);
            pw.print(")");
            pw.print(Fractal.class.getName());
            pw.print(".getAttributeController(");
            pw.print(this.id);
            pw.print(")).set");
            pw.print(mname);
            pw.print("(\"");
            pw.print(value);
            pw.println("\");  // Issue if the value is not a String (see o.o.f.juliac.desc.ComponentDesc#generateAttributes)");
        }
    }

    protected void generateHierarchy(PrintWriter pw) {
        for (ComponentDesc sub : this.subComponents) {
            String subid = sub.getID();
            pw.print(Fractal.class.getName());
            pw.print(".getContentController(");
            pw.print(this.id);
            pw.print(").addFcSubComponent(");
            pw.print(subid);
            pw.println(");");
        }
        for (ComponentDesc sub : this.subComponents) {
            sub.generateHierarchy(pw);
        }
    }

    protected void generateBindings(PrintWriter pw) {
        for (BindingDesc bdesc : this.lbindings) {
            BindingType btype = bdesc.getBindingType();
            String cltItfName = bdesc.getCltItfName();
            String srvItfName = bdesc.getSrvItfName();
            ComponentDesc srv = bdesc.getSrv();
            String srvid = srv.getID();
            pw.print(Fractal.class.getName());
            pw.print(".getBindingController(");
            pw.print(this.id);
            pw.print(").bindFc(\"");
            pw.print(cltItfName);
            pw.print("\",");
            if (btype.equals((Object)BindingType.IMPORT)) {
                pw.print(Fractal.class.getName());
                pw.print(".getContentController(");
                pw.print(srvid);
                pw.print(").getFcInternalInterface(\"");
            } else {
                pw.print(srvid);
                pw.print(".getFcInterface(\"");
            }
            pw.print(srvItfName);
            pw.println("\"));");
        }
        for (ComponentDesc sub : this.subComponents) {
            sub.generateBindings(pw);
        }
    }
}

