/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.juliac.ClassGeneratorItf;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.CompDesc;
import org.objectweb.fractal.juliac.visit.BoundedIOWriterMethodSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;
import org.objectweb.fractal.util.Fractal;

public abstract class AbstractComponentFactoryClassGenerator
implements ClassGeneratorItf {
    private String targetname;

    public AbstractComponentFactoryClassGenerator(String targetname) {
        this.targetname = targetname;
    }

    public String getTargetClassName() {
        return this.targetname;
    }

    public void generate(FileSourceCodeVisitor fv) throws IOException {
        int lastdot = this.targetname.lastIndexOf(46);
        String packagename = lastdot == -1 ? null : this.targetname.substring(0, lastdot);
        fv.visitFileHeader("/*");
        fv.visitFileHeader(" * Generated by " + this.getClass().getName() + " on: " + new Date());
        fv.visitFileHeader(" */");
        if (packagename != null) {
            fv.visitPackageName(packagename);
        }
        fv.visitImport(Component.class.getName());
        fv.visitImport(Fractal.class.getName());
        ClassSourceCodeVisitor cv = fv.visitPublicClass();
        this.generate(cv);
    }

    public void generate(ClassSourceCodeVisitor cv) throws IOException {
        int lastdot = this.targetname.lastIndexOf(46);
        String classname = this.targetname.substring(lastdot + 1);
        cv.visit(1, classname, null, null, new String[]{Factory.class.getName()});
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcContentDesc", null, null);
        mv.visitBegin();
        mv.visit("    throw new ");
        mv.visit(UnsupportedOperationException.class.getName());
        mv.visitln("();");
        mv.visitEnd();
        mv = cv.visitMethod(1, null, "Object", "getFcControllerDesc", null, null);
        mv.visitBegin();
        mv.visit("    throw new ");
        mv.visit(UnsupportedOperationException.class.getName());
        mv.visitln("();");
        mv.visitEnd();
        BoundedIOWriterMethodSourceCodeWriter writer = new BoundedIOWriterMethodSourceCodeWriter(cv);
        PrintWriter pw = new PrintWriter(writer);
        CompDesc cdesc = this.generateNewFcInstanceMethods(pw);
        pw.close();
        writer.close();
        String root = cdesc.getID();
        ComponentType ct = cdesc.getCT();
        int newFcInstanceMethodCount = writer.getNewFcInstanceMethodCount();
        mv = cv.visitMethod(1, null, "Component", "newFcInstance", null, new String[]{InstantiationException.class.getName()});
        mv.visitBegin();
        mv.visitln("    try {");
        for (int i = 0; i < newFcInstanceMethodCount; ++i) {
            mv.visitln("      newFcInstance" + Integer.toString(i) + "();");
        }
        mv.visitln("    }");
        mv.visitln("    catch( " + InstantiationException.class.getName() + " e ) {");
        mv.visitln("      throw e;");
        mv.visitln("    }");
        mv.visitln("    catch( RuntimeException e ) {");
        mv.visitln("      throw (RuntimeException) e;");
        mv.visitln("    }");
        mv.visitln("    catch( Exception e ) {");
        mv.visitln("      throw new " + ChainedInstantiationException.class.getName() + "(e,null,e.getClass().getName()+\": \"+e.getMessage());");
        mv.visitln("    }");
        mv.visitln("    return " + root + ";");
        mv.visitEnd();
        List<String> compIDs = cdesc.getCompIDs();
        if (compIDs == null) {
            String msg = "The compIDs field from CompDesc " + cdesc + " should have been set.";
            throw new NullPointerException(msg);
        }
        for (String compID : compIDs) {
            cv.visitField(2, Component.class.getName(), compID, null);
        }
        mv = cv.visitMethod(1, null, Type.class.getName(), "getFcInstanceType", null, null);
        mv.visitBegin();
        mv.visitln("    try {");
        mv.visitln("      // --------------------------------------------------");
        mv.visitln("      " + ComponentType.class.getName() + " ct = ");
        String sct = Utils.javaify(ct).toString();
        mv.visit("      ");
        mv.visit(sct);
        mv.visitln(";");
        mv.visitln("      // --------------------------------------------------");
        mv.visitln("      return ct;");
        mv.visitln("    }");
        mv.visitln("    catch( " + InstantiationException.class.getName() + " e ) {");
        mv.visit("      throw new ");
        mv.visit("org.objectweb.fractal.juliac.runtime.RuntimeException");
        mv.visitln("(e);");
        mv.visitln("    }");
        mv.visitEnd();
        try {
            InterfaceType it = ct.getFcInterfaceType("r");
            String signature = it.getFcItfSignature();
            if (signature.equals(Runnable.class.getName())) {
                mv = cv.visitMethod(9, null, "void", "main", new String[]{"String[] args"}, new String[]{InstantiationException.class.getName(), IllegalLifeCycleException.class.getName(), NoSuchInterfaceException.class.getName()});
                mv.visitBegin();
                mv.visit("    ");
                mv.visit(Factory.class.getName());
                mv.visit(" f = new ");
                mv.visit(classname);
                mv.visitln("();");
                mv.visit("    ");
                mv.visit(Component.class.getName());
                mv.visitln(" c = f.newFcInstance();");
                mv.visit("    ");
                mv.visit(Fractal.class.getName());
                mv.visitln(".getLifeCycleController(c).startFc();");
                mv.visitln("    Runnable r = (Runnable) c.getFcInterface(\"r\");");
                mv.visit("    ");
                mv.visit(Fractal.class.getName());
                mv.visitln(".getLifeCycleController(c).stopFc();");
                mv.visitEnd();
            }
        }
        catch (NoSuchInterfaceException e) {
            // empty catch block
        }
        cv.visitEnd();
    }

    protected abstract CompDesc generateNewFcInstanceMethods(PrintWriter var1) throws IOException;
}

