/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import java.io.IOException;
import java.util.Date;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.ProxyClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyClassGenerator
implements ProxyClassGenerator {
    protected InterfaceType it;
    protected MembraneDesc<?> membraneDesc;
    protected boolean mergeable;
    protected Juliac jc;

    public AbstractProxyClassGenerator() {
    }

    public AbstractProxyClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        this.setInterfaceType(it);
        this.setMembraneDesc(membraneDesc);
        this.setMergeable(mergeable);
        this.setJuliac(jc);
    }

    @Override
    public void setInterfaceType(InterfaceType it) {
        this.it = it;
    }

    @Override
    public void setMembraneDesc(MembraneDesc<?> membraneDesc) {
        this.membraneDesc = membraneDesc;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public void setJuliac(Juliac jc) {
        this.jc = jc;
    }

    @Override
    public String getTargetClassName() {
        String javaItfSignature = this.it.getFcItfSignature();
        String name = Utils.getJuliacGeneratedStrongTypeName(javaItfSignature);
        String suffix = this.getClassNameSuffix();
        String targetClassName = name + suffix;
        String rootedTargetClassName = this.jc.getRootedClassName(targetClassName);
        return rootedTargetClassName;
    }

    @Override
    public void generate(FileSourceCodeVisitor fv) throws IOException {
        this.generateFileHeaders(fv);
        String packageName = this.getPackageName();
        if (packageName != null) {
            fv.visitPackageName(packageName);
        }
        this.generateImports(fv);
        ClassSourceCodeVisitor cv = fv.visitPublicClass();
        this.generate(cv);
    }

    @Override
    public void generate(ClassSourceCodeVisitor cv) {
        int modifiers = this.getClassModifiers();
        if (this.mergeable) {
            modifiers = 1024;
        }
        String name = this.getClassName();
        String[] genericTypeParameters = this.getClassGenericTypeParameters();
        String superClassName = this.getSuperClassName();
        String[] implementedInterfaceNames = this.getImplementedInterfaceNames();
        cv.visit(modifiers, name, genericTypeParameters, superClassName, implementedInterfaceNames);
        UnifiedClass proxycl = this.jc.create(this.it.getFcItfSignature());
        this.generateFields(cv, proxycl);
        this.generateConstructors(cv, proxycl);
        this.generateMethods(cv, proxycl);
        UnifiedMethod[] proxymethods = proxycl.getMethods();
        for (int i = 0; i < proxymethods.length; ++i) {
            UnifiedMethod proxym = proxymethods[i];
            UnifiedClass rtype = proxym.getReturnType();
            String sig = proxym.toString();
            boolean samesig = false;
            for (int j = 0; j < proxymethods.length; ++j) {
                UnifiedClass otherrtype;
                UnifiedMethod otherproxym;
                String othersig;
                if (j == i || !(othersig = (otherproxym = proxymethods[j]).toString()).equals(sig) || !rtype.isAssignableFrom(otherrtype = otherproxym.getReturnType())) continue;
                samesig = true;
                break;
            }
            if (samesig) continue;
            this.generateProxyMethod(cv, proxycl, proxym);
        }
        this.generateStaticParts(cv, proxycl);
        cv.visitEnd();
    }

    @Override
    public void generateFileHeaders(FileSourceCodeVisitor fv) {
        fv.visitFileHeader("/*");
        fv.visitFileHeader(" * Generated by: " + this.getClass().getName());
        fv.visitFileHeader(" * on: " + new Date().toString());
        fv.visitFileHeader(" */");
    }

    @Override
    public String getPackageName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String packagename = targetclassname.substring(0, lastdot);
        return packagename;
    }

    @Override
    public void generateImports(FileSourceCodeVisitor fv) {
    }

    @Override
    public int getClassModifiers() {
        return 1;
    }

    @Override
    public String getClassName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        String shortclassname = targetclassname.substring(lastdot + 1);
        return shortclassname;
    }

    @Override
    public String[] getClassGenericTypeParameters() {
        UnifiedClass proxycl = this.jc.create(this.it.getFcItfSignature());
        String[] tps = proxycl.getTypeParameters();
        return tps;
    }

    @Override
    public String getSuperClassName() {
        return null;
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        return null;
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateProxyMethod(ClassSourceCodeVisitor cv, UnifiedClass proxycl, UnifiedMethod proxym) {
        int modifiers = 1;
        String[] genericReturnType = proxym.getTypeParameters();
        String returnType = proxym.getGenericReturnType();
        String name = proxym.getName();
        String[] parameters = proxym.getParameters();
        String[] exceptions = proxym.getGenericExceptionTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].startsWith("final")) continue;
            parameters[i] = "final " + parameters[i];
        }
        if (this.mergeable) {
            int mergeablemodifiers = 1025;
            String mergeablename = "_super_" + name;
            MethodSourceCodeVisitor mv = cv.visitMethod(mergeablemodifiers, genericReturnType, returnType, mergeablename, parameters, exceptions);
            mv.visitEnd();
        }
        MethodSourceCodeVisitor mv = cv.visitMethod(modifiers, genericReturnType, returnType, name, parameters, exceptions);
        mv.visitBegin();
        this.generateProxyMethodBody(mv, proxycl, proxym);
        mv.visitEnd();
    }

    @Override
    public void generateProxyMethodBody(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        this.generateProxyMethodBodyBeforeCode(mv, proxycl, proxym);
        this.generateProxyMethodBodyDelegatingCode(mv, proxycl, proxym);
        this.generateProxyMethodBodyAfterCode(mv, proxycl, proxym);
        String rtypename = proxym.getGenericReturnType();
        if (!rtypename.equals("void")) {
            mv.visitln("    return ret;");
        }
        this.generateProxyMethodBodyFinallyCode(mv, proxycl, proxym);
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyDelegatingCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        UnifiedClass[] ptypes = proxym.getParameterTypes();
        String rtypename = proxym.getGenericReturnType();
        mv.visit("    ");
        if (!rtypename.equals("void")) {
            mv.visit(rtypename + " ret = ");
        }
        String delegatingInstance = this.getDelegatingInstance(proxycl, proxym);
        String delegatingMethodName = this.getDelegatingMethodName(proxycl, proxym);
        mv.visit(delegatingInstance);
        mv.visit(".");
        mv.visit(delegatingMethodName);
        mv.visit("(");
        for (int j = 0; j < ptypes.length; ++j) {
            if (j != 0) {
                mv.visit(",");
            }
            mv.visit("arg");
            mv.visit(Integer.toString(j));
        }
        mv.visitln(");");
    }

    @Override
    public void generateProxyMethodBodyAfterCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public String getDelegatingMethodName(UnifiedClass proxycl, UnifiedMethod proxym) {
        String name = proxym.getName();
        if (this.mergeable) {
            return "_super_" + name;
        }
        return name;
    }
}

