/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.control.attribute.CloneableAttributeController;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractProxyClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeControllerClassGenerator
extends AbstractProxyClassGenerator {
    private List<String> settableAttrs;

    public AttributeControllerClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public boolean match() {
        return true;
    }

    @Override
    public String getClassNameSuffix() {
        return "AC";
    }

    @Override
    public void setMergeable(boolean mergeable) {
        if (mergeable) {
            String msg = "This generator can not generate mergeable code";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        return new String[]{this.it.getFcItfSignature(), CloneableAttributeController.class.getName()};
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        ArrayList<String> attrs = new ArrayList<String>();
        this.settableAttrs = new ArrayList<String>();
        UnifiedMethod[] proxymethods = proxycl.getMethods();
        for (int i = 0; i < proxymethods.length; ++i) {
            UnifiedClass type;
            UnifiedMethod m = proxymethods[i];
            String mname = m.getName();
            if (!mname.startsWith("get") && !mname.startsWith("set")) continue;
            String attrname = mname.substring(3);
            if (mname.startsWith("set")) {
                this.settableAttrs.add(attrname);
                if (!attrs.contains(attrname)) {
                    type = m.getParameterTypes()[0];
                    cv.visitField(2, type.getName(), attrname, null);
                }
                cv.visitField(2, "boolean", "_" + attrname, null);
            } else if (!attrs.contains(attrname)) {
                type = m.getReturnType();
                cv.visitField(2, type.getName(), attrname, null);
            }
            attrs.add(attrname);
        }
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        MethodSourceCodeVisitor mv = cv.visitConstructor(1, null, null, null);
        mv.visitBegin();
        mv.visitEnd();
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "cloneFcAttributes", new String[]{AttributeController.class.getName() + " attributecontroller"}, null);
        mv.visitBegin();
        for (String attr : this.settableAttrs) {
            mv.visit("    if(_");
            mv.visit(attr);
            mv.visitln(")");
            mv.visit("      ((");
            mv.visit(this.it.getFcItfSignature());
            mv.visit(")attributecontroller).set");
            mv.visit(attr);
            mv.visit("(");
            mv.visit(attr);
            mv.visitln(");");
        }
        mv.visitEnd();
    }

    @Override
    public void generateProxyMethodBody(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        String mname = proxym.getName();
        String attrname = mname.substring(3);
        if (mname.startsWith("set")) {
            mv.visitln("    " + attrname + " = arg0;");
            mv.visitln("    _" + attrname + " = true;");
        } else {
            mv.visitln("    return " + attrname + ";");
        }
    }

    @Override
    public String getDelegatingInstance(UnifiedClass proxycl, UnifiedMethod proxym) {
        throw new UnsupportedOperationException();
    }
}

