/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractInterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleSourceCodeGenerator
extends AbstractInterceptorSourceCodeGenerator {
    public LifeCycleSourceCodeGenerator() {
    }

    public LifeCycleSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public String getClassNameSuffix() {
        String suffix = "LC";
        if (!this.mergeable) {
            String lcCtrlImplName = this.getLCCtrlImplName();
            int hash = lcCtrlImplName.hashCode();
            String hexhash = Integer.toHexString(hash);
            suffix = suffix + hexhash;
        }
        return suffix;
    }

    @Override
    public boolean match() {
        if (this.it.isFcClientItf()) {
            return false;
        }
        String name = this.it.getFcItfName();
        if (name.startsWith("//")) {
            return true;
        }
        return !name.endsWith("-controller") && !name.equals("component");
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (this.mergeable) {
            cv.visitField(1, "int", "_this_fcState", null);
            cv.visitField(1, "int", "_this_fcInvocationCounter", null);
        } else {
            String lcCtrlImplName = this.getLCCtrlImplName();
            cv.visitField(2, lcCtrlImplName, "_lc", null);
        }
    }

    @Override
    public void generateMethodInitFcController(MethodSourceCodeVisitor mv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            String lcCtrlImplName = this.getLCCtrlImplName();
            mv.visitln("    Object olc = ic.getInterface(\"lifecycle-controller\");");
            mv.visit("    if( ! (olc instanceof ");
            mv.visit(lcCtrlImplName);
            mv.visitln(") ) {");
            mv.visit("      while( olc instanceof ");
            mv.visit(Interceptor.class.getName());
            mv.visitln(" ) {");
            mv.visit("        olc = ((");
            mv.visit(Interceptor.class.getName());
            mv.visitln(")olc).getFcItfDelegate();");
            mv.visitln("      }");
            mv.visitln("    }");
            mv.visit("    _lc = (");
            mv.visit(lcCtrlImplName);
            mv.visitln(") olc;");
        }
    }

    @Override
    public void generateMethodClone(MethodSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitln("    clone._lc = _lc;");
    }

    @Override
    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitMethod(1025, null, "void", "_this_incrementFcInvocationCounter", null, null);
            mv.visitEnd();
            mv = cv.visitMethod(1025, null, "void", "_this_decrementFcInvocationCounter", null, null);
            mv.visitEnd();
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        if (this.mergeable) {
            mv.visitln("      synchronized(this) {");
            mv.visitln("        if(_this_fcState != 2)");
            mv.visitln("          _this_incrementFcInvocationCounter();");
            mv.visitln("        else");
            mv.visitln("          _this_fcInvocationCounter++;");
        } else {
            mv.visitln("      synchronized(_lc) {");
            mv.visitln("        if(_lc.fcState != 2)");
            mv.visitln("          _lc.incrementFcInvocationCounter();");
            mv.visitln("        else");
            mv.visitln("          _lc.fcInvocationCounter++;");
        }
        mv.visitln("      }");
        mv.visitln("      try {");
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        mv.visitln("      }");
        mv.visitln("      finally {");
        if (this.mergeable) {
            mv.visitln("        synchronized(this) {");
            mv.visitln("          if(_this_fcState != 2)");
            mv.visitln("            _this_decrementFcInvocationCounter();");
            mv.visitln("          else");
            mv.visitln("            _this_fcInvocationCounter--;");
        } else {
            mv.visitln("        synchronized(_lc) {");
            mv.visitln("          if(_lc.fcState != 2)");
            mv.visitln("            _lc.decrementFcInvocationCounter();");
            mv.visitln("          else");
            mv.visitln("            _lc.fcInvocationCounter--;");
        }
        mv.visitln("        }");
        mv.visitln("      }");
    }

    private String getLCCtrlImplName() {
        String signature = LifeCycleController.class.getName();
        UnifiedClass uc = this.membraneDesc.getCtrlImpl(signature, this.jc);
        String name = uc.getName();
        return name;
    }
}

