/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;

public class BlockSourceCodeWriter
implements BlockSourceCodeVisitor {
    protected PrintWriter pw;
    private int state = 0;
    private static final int BEGIN_STATE = 0;
    private static final int BODY_STATE = 1;
    private static final int FINAL_STATE = 2;

    public BlockSourceCodeWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void visitBegin() {
        if (this.state != 0) {
            String msg = "Block beginning can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.println('{');
        this.state = 1;
    }

    public void visit(String code) {
        if (this.state != 1) {
            String msg = "Block body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print(code);
    }

    public void visitln(String code) {
        if (this.state != 1) {
            String msg = "Block body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.println(code);
    }

    public void visitEnd() {
        if (this.state != 1) {
            String msg = "Block end can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("  ");
        this.pw.println('}');
        this.pw.println();
        this.state = 2;
    }
}

