/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeWriter;

public class ClassSourceCodeWriter
implements ClassSourceCodeVisitor {
    protected PrintWriter pw;
    private String className;
    private int state = 1;
    private static final int DECLARATION_STATE = 1;
    private static final int BODY_STATE = 2;
    private static final int END_STATE = 3;
    private static final int FINAL_STATE = 4;

    public ClassSourceCodeWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void visit(int modifiers, String name, String[] genericTypeParameters, String superClassName, String[] implementedInterfaceNames) {
        if (this.state < 1) {
            this.state = 1;
        }
        if (this.state != 1) {
            String msg = "Class declaration can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.className = name;
        this.pw.println();
        this.pw.print(Modifier.toString(modifiers));
        this.pw.print(" class ");
        this.pw.print(name);
        this.visitGenericType(genericTypeParameters);
        if (superClassName != null) {
            this.pw.println();
            this.pw.print("extends ");
            this.pw.print(superClassName);
        }
        if (implementedInterfaceNames != null) {
            this.pw.println();
            this.pw.print("implements ");
            boolean first = true;
            for (String implementedInterfaceName : implementedInterfaceNames) {
                if (first) {
                    first = false;
                } else {
                    this.pw.print(',');
                }
                this.pw.print(implementedInterfaceName);
            }
        }
        this.pw.println(" {");
        this.pw.println();
        this.state = 2;
    }

    public BlockSourceCodeVisitor visitStaticPart() {
        if (this.state != 2) {
            String msg = "Class body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("  static ");
        return new BlockSourceCodeWriter(this.pw);
    }

    public void visitField(int modifiers, String type, String name, String expression) {
        if (this.state != 2) {
            String msg = "Class body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("  ");
        this.pw.print(Modifier.toString(modifiers));
        this.pw.print(' ');
        this.pw.print(type);
        this.pw.print(' ');
        this.pw.print(name);
        if (expression != null) {
            this.pw.print(" = ");
            this.pw.print(expression);
        }
        this.pw.println(';');
    }

    public MethodSourceCodeVisitor visitConstructor(int modifiers, String[] genericTypeParameters, String[] parameters, String[] exceptions) {
        if (this.state != 2) {
            String msg = "Class body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("  ");
        this.pw.print(Modifier.toString(modifiers));
        this.pw.print(' ');
        this.visitGenericType(genericTypeParameters);
        this.pw.print(this.className);
        this.visitParameters(parameters);
        this.visitExceptions(exceptions);
        this.pw.print(' ');
        return new MethodSourceCodeWriter(this.pw);
    }

    public MethodSourceCodeVisitor visitMethod(int modifiers, String[] typeParameters, String returnType, String name, String[] parameters, String[] exceptions) {
        if (this.state != 2) {
            String msg = "Class body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("  ");
        this.pw.print(Modifier.toString(modifiers));
        this.pw.print(' ');
        this.visitGenericType(typeParameters);
        this.pw.print(returnType);
        this.pw.print(' ');
        this.pw.print(name);
        this.visitParameters(parameters);
        this.visitExceptions(exceptions);
        this.pw.print(' ');
        return new MethodSourceCodeWriter(this.pw);
    }

    public ClassSourceCodeVisitor visitInnerClass() {
        if (this.state != 2) {
            String msg = "Class body can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        return new ClassSourceCodeWriter(this.pw);
    }

    public void visitEnd() {
        if (this.state == 1 || this.state == 2) {
            this.state = 3;
        }
        if (this.state != 3) {
            String msg = "Class end can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.println('}');
        this.state = 4;
    }

    private void visitGenericType(String[] genericTypeParameters) {
        if (genericTypeParameters != null && genericTypeParameters.length != 0) {
            this.pw.print('<');
            boolean first = true;
            for (String genericTypeParameter : genericTypeParameters) {
                if (first) {
                    first = false;
                } else {
                    this.pw.print(',');
                }
                this.pw.print(genericTypeParameter);
            }
            this.pw.print("> ");
        }
    }

    private void visitParameters(String[] parameters) {
        this.pw.print('(');
        if (parameters != null) {
            boolean first = true;
            for (String parameter : parameters) {
                if (first) {
                    first = false;
                } else {
                    this.pw.print(',');
                }
                this.pw.print(parameter);
            }
        }
        this.pw.print(") ");
    }

    private void visitExceptions(String[] exceptions) {
        if (exceptions != null && exceptions.length != 0) {
            this.pw.print("throws ");
            boolean first = true;
            for (String exception : exceptions) {
                if (first) {
                    first = false;
                } else {
                    this.pw.print(',');
                }
                this.pw.print(exception);
            }
            this.pw.print(' ');
        }
    }
}

