/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

public class FileSourceCodeWriter
implements FileSourceCodeVisitor {
    protected PrintWriter pw;
    private int state = 0;
    private static final int FILE_HEADER_STATE = 0;
    private static final int PACKAGE_NAME_STATE = 1;
    private static final int IMPORTS_STATE = 2;
    private static final int CLASS_STATE = 3;
    private static final int END_STATE = 4;

    public FileSourceCodeWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void visitFileHeader(String header) {
        if (this.state != 0) {
            String msg = "File headers can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.println(header);
    }

    public void visitPackageName(String name) {
        if (this.state < 1) {
            this.state = 1;
        }
        if (this.state != 1) {
            String msg = "Package name can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.println();
        this.pw.print("package ");
        this.pw.print(name);
        this.pw.println(';');
        this.pw.println();
        this.state = 2;
    }

    public void visitImport(String name) {
        if (this.state < 2) {
            this.state = 2;
        }
        if (this.state != 2) {
            String msg = "Imports can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.pw.print("import ");
        this.pw.print(name);
        this.pw.println(';');
    }

    public ClassSourceCodeVisitor visitPublicClass() {
        if (this.state < 3) {
            this.state = 3;
        }
        if (this.state != 3) {
            String msg = "Class declaration can not be visited at this stage of the visit";
            throw new IllegalStateException(msg);
        }
        this.state = 4;
        return new ClassSourceCodeWriter(this.pw);
    }
}

