package org.ow2.petals.bc.filetransfer.steps;

import java.io.File
import java.io.FileWriter

import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.ow2.petals.bc.filetransfer.FileTransferConstants
import org.ow2.petals.components.steps.AbstractOrchestratorComponentSteps

import com.ebmwebsourcing.easycommons.io.FileSystemHelper


class AbstractFiletransferComponentSteps extends AbstractOrchestratorComponentSteps {

    static final String FOLDER_PARAM_NAME = new QName(FileTransferConstants.FILETRANSFER_SERVICE_NS, FileTransferConstants.PARAM_FOLDER).toString();
    static final String FILENAME_PARAM_NAME = new QName(FileTransferConstants.FILETRANSFER_SERVICE_NS, FileTransferConstants.PARAM_FILENAME).toString();

    @Given("a temporary directory")
    def createTemporaryDirectory(){
        this.temporaryDirectory = FileSystemHelper.createTempDir("fileTransferDir");
    }

    @Given("an external file available at path <relativePath>, relative to this temporary directory")
    def externalFileAvailableAt(
    String relativePath) {
        File externalFile = new File(temporaryDirectory, relativePath);
        folder = externalFile.getParentFile();
        folder.mkdirs();
        filename = externalFile.getName();

        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(externalFile);
            fileWriter.write("<test>This is the file to get or delete</test>");
        } finally {
            if(fileWriter != null) {
                fileWriter.close();
            }
        }
    }
}

