package org.ow2.petals.bc.filetransfer.steps;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore

import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.When
import org.ow2.petals.bc.filetransfer.FileTransferConstants;
import org.ow2.petals.bc.filetransfer.FileTransferConsumeFlowStepBeginLogData;
import org.ow2.petals.component.api.ComponentConfiguration
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.component.api.ServiceConfiguration.ServiceType;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.JbiConstants;
import com.ebmwebsourcing.jbi.adaptor.impl.transport.RequestResponseTransporter

public class IdentifyFiletransferConsumerBeginStepSteps extends AbstractFiletransferComponentSteps {

    @Given("""a <directory>""")
    def aSoapComponentConfiguredToReceiveRequest(
    String directory) {
        this.directory = new File(directory);
        FileSystemHelper.deleteDirectory(this.directory);
        this.directory.mkdirs();
    }

    @Given("""a filetransfer component <componentName> is configured on <nodeName> 
to poll this temporary directory every <pollingPeriod> second(s) 
so that putting a file in this directory is bound to invocation of this jsr-181 service""")
    def aSoapComponentConfiguredToReceiveRequest(
    String nodeName,
    String componentName,
    int pollingPeriod) {
        ComponentConfiguration componentConfiguration = createComponentConfiguration(componentName);

        this.component = createAndStartComponent(ComponentType.BC_FILETRANSFER, componentConfiguration);

        ServiceConfiguration consumeServiceConfiguration = new ServiceConfiguration("IdentifyFiletransferConsumer",
                this.provideJsr181ServiceConfiguration.getInterfaceQName(),
                this.provideJsr181ServiceConfiguration.getServiceQName(),
                this.provideJsr181ServiceConfiguration.getEndpointName(),
                ServiceConfiguration.ServiceType.CONSUME);
        consumeServiceConfiguration.setParameter("{"
                + JbiConstants.CDK_NAMESPACE_URI + "}"
                + "operation", this.provideJsr181OperationName);
        consumeServiceConfiguration.setParameter("{"
                + FileTransferConstants.FILETRANSFER_SERVICE_NS + "}"
                + FileTransferConstants.PARAM_FOLDER, this.directory.getAbsolutePath());
        consumeServiceConfiguration.setParameter("{"
                + FileTransferConstants.FILETRANSFER_SERVICE_NS + "}"
                + FileTransferConstants.PARAM_TRANSFER_MODE, FileTransferConstants.ENUM_TRANSFER_MODE_CONTENT);
        consumeServiceConfiguration.setParameter("{"
                + FileTransferConstants.FILETRANSFER_SERVICE_NS + "}"
                + FileTransferConstants.PARAM_POLLING_PERIOD, String.valueOf(pollingPeriod));


        this.component.installService(consumeServiceConfiguration);
    }

    @When("a <file> is put in this temporary directory")
    def aFileIsPutIntoPolledDirectory(String file) {
        generateExternalEvent(file);
        RequestResponseTransporter requestResponseTransporter = new RequestResponseTransporter(this.component, this.jsr181Component);
        requestResponseTransporter.transport();
    }

    protected void generateExternalEvent(String fileName) throws Exception {
        File tempFile = createXmlFile();
        File filePathToPoll = new File(this.directory, fileName);
        tempFile.renameTo(filePathToPoll);
    }

    private File createXmlFile() throws Exception {
        File tempFile = File.createTempFile("filetransferTest", ".xml");
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        String xmlText = "<jsr:inOnlyOperationRequest xmlns:jsr='http://jsr181Provider/'>toto</jsr:inOnlyOperationRequest>";
        outputStream.write(xmlText.getBytes());
        return tempFile;
    }
}
