package org.ow2.petals.bc.filetransfer.steps;

import org.ow2.petals.component.api.ServiceConfiguration;

import java.net.URL

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message;
import org.ow2.petals.component.api.ServiceConfiguration

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage


class IdentifyFiletransferProviderBeginStepSteps extends AbstractFiletransferComponentSteps {


    @Given("""a filetransfer component <componentName> configured on <nodeName>
              imports this file as an internal service
              <interfaceName>,<serviceName>,<endpointName>""")
    public void givenAFiletransferComponentConfigured(
    String nodeName,
    String componentName,
    String interfaceName,
    String serviceName,
    String endpointName) {
        this.component = createAndStartComponent(ComponentType.BC_FILETRANSFER, 
            createComponentConfiguration(componentName));

        thisInternalService = new ServiceConfiguration("identifyFileTransferProvideStep",
                QName.valueOf(interfaceName),
                QName.valueOf(serviceName),
                endpointName,
                ServiceConfiguration.ServiceType.PROVIDE);

        thisInternalService.setParameter(FOLDER_PARAM_NAME, folder.getAbsolutePath());
        thisInternalService.setParameter(FILENAME_PARAM_NAME, filename);

        component.installService(thisInternalService);
    }


    @When("""a request is received by this internal service with <operationName>,
             the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def aRequestIsReceivedByThisInternalService(
    String operationName,
    String flowInstanceId,
    String previousStepId) {

        Message message;
        if(operationName.equals("{http://petals.ow2.org/components/filetransfer/version-3}get")) {
            String payload = "<ver:get xmlns:ver='http://petals.ow2.org/components/filetransfer/version-3'><ver:filename>" + filename + "</ver:filename></ver:get>";
            message = new WrappedRequestMessage(thisInternalService,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId, previousStepId));
        } else {
            String payload = "<ver:del xmlns:ver='http://petals.ow2.org/components/filetransfer/version-3'><ver:filename>" + filename + "</ver:filename></ver:del>";
            message = new WrappedRequestMessage(thisInternalService,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId, previousStepId));
        }

        this.component.pushMessage(message);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

