Story: identify filetransfer consumer start step

Scenario: with MONIT enabled

Given the ESB only composed of <nodeHost> known as <nodeName>

And MONIT enabled on <nodeName>

Given a jsr-181 component <providerComponentName> configured on <nodeName>
so that operation <providerOperationName> of internal service 
<providerInterfaceName>,<providerServiceName>,<providerEndpointName> is bound to java method execution

Given a <directory> 

Given a filetransfer component <componentName> is configured on <nodeName> 
to poll this temporary directory every <pollingPeriod> second(s) 
so that putting a file in this directory is bound to invocation of this jsr-181 service

When a <file> is put in this temporary directory

Then after <processingDelay> second(s), 
a MONIT record is logged on <nodeName> by <componentName> 
containing strictly following info in this order:
| key             | matcher | value |
| traceCode       | equals  | consumeFlowStepBegin |
| flowInstanceId  | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
| flowStepId      | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
|flowInterfaceName| equals  | providerInterfaceName |
|flowServiceName  | equals  | providerServiceName |
|flowEndpointName | equals  | providerEndpointName |
|flowOperationName| equals  | providerOperationName |
|filePath         | equals  | directory/file |

Examples:
| nodeHost  | nodeName | componentName          | directory       | file     | providerInterfaceName                          | providerServiceName                          | providerEndpointName  | providerOperationName                    | providerComponentName | pollingPeriod | processingDelay|
| localhost | node1    | petals-bc-filetransfer | /tmp/acceptance | test.txt | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOnlyOperation | petals-se-jsr-181    | 2             | 3              |
