/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.jbidescriptor;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilderHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JBIDescriptorBuilder {
    public static final String CDKJBI_XSD = "CDKjbi.xsd";
    public static final String ABSTRACT_CDKJBI_XSD = "abstractCDKjbi.xsd";
    public static final String CDKEXTENSIONS_XSD = "CDKextensions.xsd";
    private static SchemaFactory factory;
    private static Unmarshaller unmarshaller;
    private static Object unmarshallerSync;
    private static CDKJBIDescriptorException unmarshCreationEx;
    private static Marshaller marshaller;
    private static Object marshallerSync;
    private static CDKJBIDescriptorException marshallerCreationEx;

    public static void validateJBIDescriptor(InputStream jbiDescriptorStream) throws CDKJBIDescriptorException {
        Validator validator = JBIDescriptorBuilder.getUnMarshaller().getSchema().newValidator();
        try {
            validator.validate(new StreamSource(jbiDescriptorStream));
        }
        catch (SAXException e) {
            throw new CDKJBIDescriptorException("Failed to validate JBI descriptor against JBI schema", e);
        }
        catch (IOException e) {
            throw new CDKJBIDescriptorException("Failed to validate JBI descriptor against JBI schema", e);
        }
    }

    public static void validateJBIDescriptor(InputStream jbiDescriptorStream, String componentName) throws CDKJBIDescriptorException {
        URL cdkExtUrl = JBIDescriptorBuilder.class.getResource("/CDKextensions.xsd");
        URL componentExtUrl = JBIDescriptorBuilder.class.getResource("/" + componentName + "extensions.xsd");
        URL cdkSchemaUrl = JBIDescriptorBuilder.class.getResource("/abstractCDKjbi.xsd");
        URL componentSchemaUrl = JBIDescriptorBuilder.class.getResource("/" + componentName + "jbi.xsd");
        try {
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(cdkExtUrl.openStream()), new StreamSource(componentExtUrl.openStream()), new StreamSource(cdkSchemaUrl.openStream()), new StreamSource(componentSchemaUrl.openStream())});
            schema.newValidator().validate(new StreamSource(jbiDescriptorStream));
        }
        catch (SAXException e) {
            throw new CDKJBIDescriptorException("Failed to create the CDK component specific schema validation", e);
        }
        catch (IOException e) {
            throw new CDKJBIDescriptorException("Failed to create the CDK component specific schema validation", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jbi buildJavaJBIDescriptor(InputStream jbiDescriptorStream) throws CDKJBIDescriptorException {
        try {
            JAXBElement root;
            Object object = unmarshallerSync;
            synchronized (object) {
                root = JBIDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(jbiDescriptorStream), Jbi.class);
            }
            return (Jbi)root.getValue();
        }
        catch (JAXBException e) {
            throw new CDKJBIDescriptorException("Failed to build jbi descriptor", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlJBIdescriptor(Jbi jbiDescriptorClass, Node jbiDescriptorNode) throws CDKJBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbiDescriptorClass, jbiDescriptorNode);
            }
        }
        catch (JAXBException e) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildXmlJBIdescriptor(Jbi jbiDescriptorClass) throws CDKJBIDescriptorException {
        Document document = JBIDescriptorBuilder.getDocumentBuilder().newDocument();
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbiDescriptorClass, (Node)document);
            }
        }
        catch (JAXBException e) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", e);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlJBIdescriptor(Jbi jbiDescriptorClass, OutputStream ouputStream) throws CDKJBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbiDescriptorClass, ouputStream);
            }
        }
        catch (JAXBException e) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", e);
        }
    }

    private static Unmarshaller getUnMarshaller() throws CDKJBIDescriptorException {
        if (unmarshCreationEx != null) {
            throw unmarshCreationEx;
        }
        return unmarshaller;
    }

    private static Marshaller getMarshaller() throws CDKJBIDescriptorException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    private static DocumentBuilder getDocumentBuilder() throws CDKJBIDescriptorException {
        try {
            return DocumentBuilderHelper.getNamespaceDocumentBuilder();
        }
        catch (RuntimeException e) {
            throw new CDKJBIDescriptorException("Failed to create the Document Builder", e);
        }
    }

    static {
        unmarshallerSync = new Object();
        marshallerSync = new Object();
        factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL cdkSchemaUrl = JBIDescriptorBuilder.class.getResource("/CDKjbi.xsd");
        URL cdkExtUrl = JBIDescriptorBuilder.class.getResource("/CDKextensions.xsd");
        try {
            InputStream cdkSchemaInputStream = cdkExtUrl.openStream();
            InputStream cdkExtInputStream = cdkSchemaUrl.openStream();
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(cdkSchemaInputStream), new StreamSource(cdkExtInputStream)});
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Jbi.class});
            try {
                unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                unmarshCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB unmarshaller", e);
            }
            try {
                marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (JAXBException e) {
                marshallerCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB marshaller", e);
            }
            cdkSchemaInputStream.close();
            cdkExtInputStream.close();
        }
        catch (Exception e) {
            unmarshCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB unmarshaller", e);
            marshallerCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB marshaller and unmarshaller", e);
        }
    }
}

