/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMHelper {
    private DOMHelper() {
    }

    public static DOMSource parseAsDOMSource(URL url) {
        assert (url != null);
        try {
            return DOMHelper.parseAsDOMSource(url.openStream());
        }
        catch (IOException ioe) {
            throw new UncheckedException(String.format("Cannot open stream for URL '%s'", url.toString()), ioe);
        }
    }

    public static DOMSource parseAsDOMSource(InputStream is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Document doc = dbf.newDocumentBuilder().parse(is);
            DOMSource domSource = new DOMSource(doc);
            return domSource;
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public static DOMSource parseAsDOMSource(String testResourceName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            URL resourceURL = DOMHelper.class.getResource(testResourceName);
            assert (resourceURL != null);
            Document doc = dbf.newDocumentBuilder().parse(resourceURL.toURI().toString());
            DOMSource domSource = new DOMSource(doc);
            domSource.setSystemId(resourceURL.toString());
            return domSource;
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public static Node stripEmptyTextNodes(Node node) {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        String xpathStr = "//text()[normalize-space(.) = '']";
        try {
            XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
            return node;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(String.format("Problem while evaluating xpath '%s'.", "//text()[normalize-space(.) = '']"));
        }
    }

    public static boolean areDOMNodeEqualRegardlessOfNamespaceBindings(Node n1, Node n2) {
        int i;
        Node child2;
        if (n1 == n2) {
            return true;
        }
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (n1.getNodeName() == null ? n1.getNodeName() != null : !n1.getNodeName().equals(n2.getNodeName())) {
            return false;
        }
        if (n1.getLocalName() == null ? n2.getLocalName() != null : !n1.getLocalName().equals(n2.getLocalName())) {
            return false;
        }
        if (n1.getNamespaceURI() == null ? n2.getNamespaceURI() != null : !n1.getNamespaceURI().equals(n2.getNamespaceURI())) {
            return false;
        }
        if (n1.getPrefix() == null ? n2.getPrefix() != null : !n1.getPrefix().equals(n2.getPrefix())) {
            return false;
        }
        if (n1.getNodeValue() == null ? n2.getNodeValue() != null : !n1.getNodeValue().equals(n2.getNodeValue())) {
            return false;
        }
        Node child1 = n1.getFirstChild();
        for (child2 = n2.getFirstChild(); child1 != null && child2 != null; child1 = child1.getNextSibling(), child2 = child2.getNextSibling()) {
            if (child1.isEqualNode(child2)) continue;
            return false;
        }
        if (child1 != child2) {
            return false;
        }
        NamedNodeMap map1 = n1.getAttributes();
        NamedNodeMap map2 = n2.getAttributes();
        int len = map1.getLength();
        for (i = 0; i < len; ++i) {
            Node an2;
            Node an1 = map1.item(i);
            assert (an1.getLocalName() != null);
            if (an1.getNamespaceURI() != null && an1.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || (an2 = map2.getNamedItemNS(an1.getNamespaceURI(), an1.getLocalName())) != null && an1.isEqualNode(an2)) continue;
            return false;
        }
        len = map2.getLength();
        for (i = 0; i < len; ++i) {
            Node an1;
            Node an2 = map2.item(i);
            assert (an2.getLocalName() != null);
            if (an2.getNamespaceURI() != null && an2.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || (an1 = map2.getNamedItemNS(an2.getNamespaceURI(), an2.getLocalName())) != null && an2.isEqualNode(an1)) continue;
            return false;
        }
        return true;
    }

    public static void prettyPrint(Node node, OutputStream os) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(node), new StreamResult(os));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String findDefaultNamespace(Node node) {
        String nodePrefix = node.getPrefix();
        if (nodePrefix == null) {
            return node.getNamespaceURI();
        }
        Node xmlnsNode = node.getAttributes().getNamedItem("xmlns");
        if (xmlnsNode != null) {
            return xmlnsNode.getNodeValue();
        }
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            return null;
        }
        return DOMHelper.findDefaultNamespace(parentNode);
    }
}

