/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLHelper {
    public static final String toString(NodeList list) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            Node cNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                cNode = list.item(i);
                if (cNode.getNodeType() == 3 || cNode.getNodeType() == 4) {
                    sb.append(cNode.getTextContent());
                    continue;
                }
                sb.append(XMLPrettyPrinter.prettyPrint(list.item(i)));
            }
        }
        return sb.toString();
    }

    public static final String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLHelper.createStringFromDOMNode(document, false);
    }

    public static final String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLHelper.createStringFromDOMNode(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        assert (node != null);
        node.normalize();
        DOMSource source = new DOMSource(node);
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        Transformer transformer = Transformers.takeTransformer();
        transformer.setOutputProperty("method", "xml");
        if (omitDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        try {
            transformer.transform(source, resultStream);
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDocument(Document document, OutputStream outputStream) throws TransformerException {
        assert (document != null);
        assert (outputStream != null);
        Transformer transformer = Transformers.takeTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        try {
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }
}

