/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdls;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.petals.component.framework.api.util.EndpointUtil;
import org.w3c.dom.Document;

public final class WSDLUtilImpl {
    public static final Description createLightWSDL20Description(QName interfaceQName, QName serviceQName, String endpointName) throws WSDLException {
        if (!interfaceQName.getNamespaceURI().equals(serviceQName.getNamespaceURI())) {
            throw new WSDLException("The interface namespace '" + interfaceQName.getNamespaceURI() + "' must be the same than the service namespace '" + serviceQName.getNamespaceURI() + "' to build a light WSDL");
        }
        Description wsdlDescription = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description((AbsItfDescription)WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL20));
        wsdlDescription.setTargetNamespace(interfaceQName.getNamespaceURI());
        wsdlDescription.setQName(new QName("autoGenerated"));
        InterfaceType interfazz = (InterfaceType)wsdlDescription.createInterface();
        interfazz.setQName(interfaceQName);
        wsdlDescription.addInterface((AbsItfInterfaceType)interfazz);
        Service service = (Service)wsdlDescription.createService();
        service.setQName(serviceQName);
        service.setInterface((AbsItfInterfaceType)interfazz);
        Endpoint endpoint = (Endpoint)service.createEndpoint();
        endpoint.setName(endpointName);
        service.addEndpoint((AbsItfEndpoint)endpoint);
        wsdlDescription.addService((AbsItfService)service);
        return wsdlDescription;
    }

    public static final List<Endpoint> getEndpointList(Description wsdlDescription, QName serviceQNameFilter, String endpointNameFilter) {
        ArrayList<Endpoint> endpointList = new ArrayList<Endpoint>();
        Endpoint endpoint = null;
        if (wsdlDescription != null) {
            if (serviceQNameFilter == null) {
                List serviceList = wsdlDescription.getServices();
                for (Service service : serviceList) {
                    if (service == null) continue;
                    if (endpointNameFilter == null) {
                        endpointList.addAll(service.getEndpoints());
                        continue;
                    }
                    endpoint = (Endpoint)service.getEndpoint(endpointNameFilter);
                    if (endpoint == null) continue;
                    endpointList.add((Endpoint)service.getEndpoint(endpointNameFilter));
                }
            } else {
                Service service = (Service)wsdlDescription.getService(serviceQNameFilter);
                if (service != null) {
                    if (endpointNameFilter == null) {
                        endpointList.addAll(service.getEndpoints());
                    } else {
                        endpoint = (Endpoint)service.getEndpoint(endpointNameFilter);
                        if (endpoint != null) {
                            endpointList.add((Endpoint)service.getEndpoint(endpointNameFilter));
                        }
                    }
                }
            }
        }
        return endpointList;
    }

    public static final List<Endpoint> getEndpointList(Description wsdlDescription) {
        return WSDLUtilImpl.getEndpointList(wsdlDescription, null, null);
    }

    public static final Description createWsdlDescription(URL wsdlLocation) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(wsdlLocation, false, true);
    }

    public static final Description createWsdlDescription(URL wsdlLocation, boolean processAutogenerateEndpoint) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(wsdlLocation, processAutogenerateEndpoint, true);
    }

    public static final Description createWsdlDescription(URL wsdlLocation, boolean processAutogenerateEndpoint, boolean addImportedDocumentsInWsdl) throws WSDLException {
        String autogeneratedEndpointName = null;
        if (wsdlLocation == null) {
            return null;
        }
        try {
            Description description = WSDL4ComplexWsdls.getDefaultReader().read(wsdlLocation);
            if (addImportedDocumentsInWsdl) {
                description.addImportedDocumentsInWsdl();
            }
            if (processAutogenerateEndpoint) {
                List<Endpoint> endpointList = WSDLUtilImpl.getEndpointList(description, null, "autogenerate");
                for (Endpoint endpoint : endpointList) {
                    autogeneratedEndpointName = EndpointUtil.generateEndpointName();
                    endpoint.setName(autogeneratedEndpointName);
                }
            }
            return description;
        }
        catch (URISyntaxException e) {
            throw new WSDLException("Failed to parse the WSDL", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("Failed to read the WSDL", (Throwable)e);
        }
    }

    public static final Document convertDescriptionToDocument(Description wsdlDescription) throws WSDLException {
        return WSDL4ComplexWsdls.getDefaultWriter().getDocument(wsdlDescription);
    }

    public static final String convertDescriptionToString(Description wsdlDescription) throws WSDLException {
        return WSDL4ComplexWsdls.getDefaultWriter().writeWSDL4ComplexWsdl(wsdlDescription);
    }

    public static final boolean isDescriptionContaining(Description wsdlDescription, ServiceEndpoint endpoint) {
        if (endpoint == null || endpoint.getServiceName() == null || endpoint.getEndpointName() == null) {
            return false;
        }
        return !WSDLUtilImpl.getEndpointList(wsdlDescription, endpoint.getServiceName(), endpoint.getEndpointName()).isEmpty();
    }

    public static final void convertDescriptionToFile(Description description, File wsdlFile) throws WSDLException {
        Document wsdlDocument = WSDLUtilImpl.convertDescriptionToDocument(description);
        StreamResult result = new StreamResult(wsdlFile);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(wsdlDocument), result);
        }
        catch (TransformerException e) {
            throw new WSDLException("Failed to write the WSDL", (Throwable)e);
        }
        catch (PoolException e) {
            throw new WSDLException("Failed to write the WSDL", (Throwable)e);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }
}

