/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilderHelper;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    private static Node lookupNodeInNodeList(String nodeName, String namespace, NodeList nl) {
        Node result = null;
        Node tmp = null;
        for (int i = 0; i < nl.getLength() && result == null; ++i) {
            tmp = nl.item(i);
            if (namespace != null && tmp.getNamespaceURI() != null && tmp.getNamespaceURI().equals(namespace) && nodeName.equals(tmp.getLocalName())) {
                result = tmp;
                continue;
            }
            if (nodeName.equals(tmp.getLocalName())) {
                result = tmp;
                continue;
            }
            if (!nodeName.equals(tmp.getNodeName())) continue;
            result = tmp;
        }
        return result;
    }

    public static Node findChild(Node node, String nodeName, String namespaceURI, boolean recursive) {
        Node result = null;
        if (node != null && nodeName != null) {
            node.normalize();
            NodeList nl = node.getChildNodes();
            result = XMLUtil.lookupNodeInNodeList(nodeName, namespaceURI, nl);
            if (result == null && recursive) {
                for (int i = 0; i < nl.getLength() && result == null; ++i) {
                    result = XMLUtil.findChild(nl.item(i), nodeName, namespaceURI, true);
                }
            }
        }
        return result;
    }

    public static String getTextContent(Node node) {
        String result = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String cdataContent;
            Node currentNode = list.item(i);
            if (currentNode.getNodeType() != 3 && currentNode.getNodeType() != 4) continue;
            result = currentNode.getNodeValue();
            Node nextSiblingNode = currentNode.getNextSibling();
            if (nextSiblingNode != null && nextSiblingNode.getNodeType() == 4 && (cdataContent = nextSiblingNode.getNodeValue()) != null) {
                result = result + cdataContent;
            }
            result = result.replace('\t', ' ').replace('\n', ' ').trim();
            break;
        }
        return result;
    }

    public static Document loadDocument(InputStream inputStream) throws IOException, SAXException {
        Document document = null;
        document = DocumentBuilderHelper.getNamespaceDocumentBuilder().parse(inputStream);
        return document;
    }

    public static Document createDocument() {
        return DocumentBuilderHelper.getNamespaceDocumentBuilder().newDocument();
    }

    public static Node findVariable(NodeList list, String variable) {
        Node node = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node cur = list.item(i);
            if (cur != null && cur.getNodeType() == 3 && cur.getNodeValue().equals(variable)) {
                node = cur;
                continue;
            }
            if (!cur.hasChildNodes()) continue;
            node = XMLUtil.findVariable(cur.getChildNodes(), variable);
        }
        return node;
    }
}

