/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.util.StringHelper;

public abstract class AbstractJMSConnection {
    private Context context;
    private String connectionFactoryName;
    private String destinationName;
    private String user;
    private String password;
    private Connection connection;
    protected Session session;
    protected Destination destination;
    private boolean transacted;

    public AbstractJMSConnection(Context jndiContext, String connectionFactoryName, String destinationName, boolean transacted, String user, String password) {
        this.context = jndiContext;
        this.connectionFactoryName = connectionFactoryName;
        this.destinationName = destinationName;
        this.user = user;
        this.password = password;
        this.transacted = transacted;
    }

    protected void init() throws PEtALSCDKException {
        ConnectionFactory connFact = AbstractJMSConnection.lookupConnectionFactory(this.context, this.connectionFactoryName);
        this.destination = AbstractJMSConnection.lookupDestination(this.context, this.destinationName);
        this.connection = AbstractJMSConnection.createConnection(connFact, this.user, this.password);
        try {
            this.session = this.connection.createSession(this.transacted, 1);
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("Can not JMS session", (Throwable)e);
        }
        this.createJMSConsumerOrProducer();
    }

    public void start() throws PEtALSCDKException {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("Can not start the JMS connection.", (Throwable)e);
        }
    }

    public abstract void createJMSConsumerOrProducer() throws PEtALSCDKException;

    public void stop() throws PEtALSCDKException {
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("Can not stop the JMS connection.", (Throwable)e);
        }
    }

    public void close() throws PEtALSCDKException {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("Can not close the JMS connection.", (Throwable)e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    private static ConnectionFactory lookupConnectionFactory(Context ctx, String connectionFactoryName) throws PEtALSCDKException {
        ConnectionFactory connFact = null;
        try {
            connFact = (ConnectionFactory)ctx.lookup(connectionFactoryName);
        }
        catch (NamingException e) {
            throw new PEtALSCDKException("ConnectionFactory '" + connectionFactoryName + "' not found in the JNDI context.", (Throwable)e);
        }
        return connFact;
    }

    private static Destination lookupDestination(Context ctx, String destinationName) throws PEtALSCDKException {
        Destination dest = null;
        try {
            dest = (Destination)ctx.lookup(destinationName);
        }
        catch (NamingException e) {
            throw new PEtALSCDKException("Destination '" + destinationName + "' not found in the JNDI context.", (Throwable)e);
        }
        return dest;
    }

    private static Connection createConnection(ConnectionFactory connectionFactory, String user, String password) throws PEtALSCDKException {
        Connection conn = null;
        try {
            conn = StringHelper.isNullOrEmpty((String)user) ? connectionFactory.createConnection() : connectionFactory.createConnection(user, password);
        }
        catch (JMSSecurityException e) {
            throw new PEtALSCDKException("Invalid user/password to connect to the JMS connectionFactory.", (Throwable)e);
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("JMS connectionFactory error.", (Throwable)e);
        }
        return conn;
    }
}

