/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.connection;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.ow2.petals.bc.jms.connection.AbstractJMSConnection;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

public abstract class AbstractJMSConnectionFactory
extends BasePoolableObjectFactory {
    private static final String JNDI_CONNECTION_FACTORY = "jndi-connection-factory";
    private static final String JNDI_PROVIDER_URL = "jndi-provider-url";
    private static final String JNDI_DESTINATION_NAME = "jndi-destination-name";
    private static final String JNDI_INITIAL_CONTEXT_FACTORY = "jndi-initial-context-factory";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String TRANSACTED = "transacted";
    private ConfigurationExtensions extensions;
    private Context context;
    private Logger logger;
    private short contextReferenceCounter;

    public AbstractJMSConnectionFactory(ConfigurationExtensions extensions, Logger logger) {
        this.logger = logger;
        this.extensions = extensions;
    }

    public void activateObject(Object connectionObject) throws Exception {
        this.logger.log(Level.FINEST, "Activate connection");
        AbstractJMSConnection connection = (AbstractJMSConnection)connectionObject;
        connection.start();
    }

    public void passivateObject(Object connectionObject) throws Exception {
        this.logger.log(Level.FINEST, "Passivate connection");
    }

    public boolean validateObject(Object connectionObject) {
        this.logger.log(Level.FINEST, "Validate connection");
        boolean result = true;
        AbstractJMSConnection connection = (AbstractJMSConnection)connectionObject;
        try {
            connection.stop();
            connection.start();
        }
        catch (PEtALSCDKException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public Object makeObject() throws Exception {
        this.logger.log(Level.FINEST, "create connection");
        if (this.contextReferenceCounter == 0) {
            this.context = this.setupContext(this.extensions);
        }
        this.contextReferenceCounter = (short)(this.contextReferenceCounter + 1);
        AbstractJMSConnection connection = this.createJmsConnection(this.context, this.extensions);
        connection.init();
        return connection;
    }

    public void destroyObject(Object obj) throws Exception {
        this.logger.log(Level.FINEST, "destroy connection");
        AbstractJMSConnection connection = (AbstractJMSConnection)obj;
        connection.close();
        this.contextReferenceCounter = (short)(this.contextReferenceCounter - 1);
        if (this.contextReferenceCounter == 0) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                throw new PEtALSCDKException("Failed to close the JNDI context", (Throwable)e);
            }
        }
    }

    protected abstract AbstractJMSConnection createJMSConnection(Context var1, String var2, String var3, String var4, String var5, boolean var6);

    private Context setupContext(ConfigurationExtensions extensions) throws PEtALSCDKException {
        InitialContext initialContext;
        Properties jndiProperties = this.createJNDIProperties(extensions);
        try {
            initialContext = new InitialContext(jndiProperties);
        }
        catch (NamingException e) {
            throw new PEtALSCDKException("Failed to create JNDI Initial Context : " + e.getMessage());
        }
        return initialContext;
    }

    private Properties createJNDIProperties(ConfigurationExtensions extensions) {
        Properties outProperties = new Properties();
        String url = extensions.get((Object)JNDI_PROVIDER_URL);
        String factory = extensions.get((Object)JNDI_INITIAL_CONTEXT_FACTORY);
        outProperties.setProperty("java.naming.provider.url", url);
        outProperties.setProperty("java.naming.factory.initial", factory);
        return outProperties;
    }

    private AbstractJMSConnection createJmsConnection(Context context, ConfigurationExtensions extensions) throws PEtALSCDKException {
        String connName = extensions.get((Object)JNDI_CONNECTION_FACTORY);
        String destName = extensions.get((Object)JNDI_DESTINATION_NAME);
        String user = extensions.get((Object)USER);
        String password = extensions.get((Object)PASSWORD);
        boolean transacted = false;
        String transac = extensions.get((Object)TRANSACTED);
        transacted = Boolean.valueOf(transac);
        return this.createJMSConnection(context, connName, destName, user, password, transacted);
    }
}

