/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.connection;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageConsumer;
import javax.naming.Context;
import org.ow2.petals.bc.jms.connection.AbstractJMSConnection;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

public class JMSConsumerConnection
extends AbstractJMSConnection {
    private MessageConsumer messageConsumer;

    public JMSConsumerConnection(Context jndiContext, String connectionFactoryName, String destinationName, boolean transacted, String user, String password) {
        super(jndiContext, connectionFactoryName, destinationName, transacted, user, password);
    }

    @Override
    public void createJMSConsumerOrProducer() throws PEtALSCDKException {
        try {
            this.messageConsumer = this.session.createConsumer(this.destination);
        }
        catch (JMSSecurityException e) {
            throw new PEtALSCDKException("Can not start JMS consumer, READ right not granted.", (Throwable)e);
        }
        catch (JMSException e) {
            throw new PEtALSCDKException("Cannot create JMS consumer for destination : " + this.destination, (Throwable)e);
        }
    }

    public MessageConsumer getMessageConsumer() {
        return this.messageConsumer;
    }
}

