/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.listener;

import java.util.logging.Level;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.bc.jms.listener.FaultManager;
import org.ow2.petals.bc.jms.listener.ResponseManager;
import org.ow2.petals.bc.jms.listener.ServiceManager;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;

public final class JBIListener
extends AbstractJBIListener {
    private FaultManager faultManager;
    private ResponseManager responseManager;
    private ServiceManager serviceManager;

    public void init() {
        this.faultManager = new FaultManager(this);
        this.responseManager = new ResponseManager(this);
        this.serviceManager = new ServiceManager(this);
    }

    public boolean onJBIMessage(Exchange exchange) {
        this.getLogger().log(Level.FINE, "onJBIMessage");
        try {
            if (exchange.getFault() != null) {
                this.faultManager.onJBIMessage(exchange);
            } else if (MessageExchange.Role.CONSUMER.equals(exchange.getRole())) {
                this.responseManager.onJBIMessage(exchange);
            } else {
                this.serviceManager.onJBIMessage(exchange);
            }
        }
        catch (PEtALSCDKException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            exchange.setError(new Exception(e.getMessage()));
        }
        return true;
    }
}

