/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.listener;

import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.ow2.petals.bc.jms.connection.JMSConsumerConnection;
import org.ow2.petals.bc.jms.connection.JMSConsumerConnectionFactory;
import org.ow2.petals.bc.jms.listener.JMSMessageListener;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;

public final class JMSExternalListener
extends AbstractExternalListener {
    private JMSConsumerConnectionFactory connectionFactory;
    private JMSConsumerConnection connection;

    public void init() {
        try {
            this.createConnectionFactory();
        }
        catch (PEtALSCDKException e) {
            this.getLogger().log(Level.SEVERE, "Can't create consumer connection factory", e);
        }
    }

    private void createConnectionFactory() throws PEtALSCDKException {
        this.connectionFactory = new JMSConsumerConnectionFactory(this.getExtensions(), this.component.getLogger());
    }

    public void start() throws PEtALSCDKException {
        try {
            this.connection = (JMSConsumerConnection)this.connectionFactory.makeObject();
            this.connectionFactory.activateObject(this.connection);
        }
        catch (Exception e1) {
            this.getLogger().log(Level.SEVERE, "Can not retrieve a JMS connection for consumes : " + this.getConsumes(), e1);
        }
        if (this.connection != null) {
            JMSMessageListener jmsMessageListener = new JMSMessageListener(this);
            MessageConsumer consumer = this.connection.getMessageConsumer();
            try {
                if (consumer != null) {
                    consumer.setMessageListener((MessageListener)jmsMessageListener);
                }
            }
            catch (JMSException e) {
                throw new PEtALSCDKException("Can not set the JMS messageListener for the JMS consumer.", (Throwable)e);
            }
        }
    }

    public void stop() throws PEtALSCDKException {
        try {
            if (this.connection != null) {
                this.connectionFactory.passivateObject(this.connection);
                this.connectionFactory.destroyObject(this.connection);
            }
        }
        catch (Exception e) {
            throw new PEtALSCDKException("Can not destroy a JMS connection for consumes : " + this.getConsumes(), (Throwable)e);
        }
    }
}

