/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.listener;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;
import org.ow2.petals.component.framework.util.SourceUtil;

public class JMSMessageListener
implements MessageListener {
    private final AbstractExternalListener externalListener;
    private final Logger logger;

    public JMSMessageListener(AbstractExternalListener externalListener) {
        this.externalListener = externalListener;
        this.logger = externalListener.getLogger();
    }

    public void onMessage(Message jmsExchange) {
        this.logger.log(Level.FINEST, "onMessage");
        ConfigurationExtensions extensions = this.externalListener.getExtensions();
        this.logger.log(Level.FINEST, "A JMS message is received from '" + extensions.get((Object)"jndi-provider-url") + "'.");
        try {
            Exchange exchange;
            if (!(jmsExchange instanceof TextMessage || jmsExchange instanceof BytesMessage || jmsExchange instanceof ObjectMessage)) {
                this.logger.log(Level.SEVERE, "Only TextMessage, BytesMessage or ObjectMessage are supported." + jmsExchange.getClass().getName());
            }
            try {
                exchange = this.externalListener.createConsumeExchange();
                if (exchange == null) {
                    this.logger.log(Level.WARNING, "An invalid pattern is specified in consumes extensions. So an in-only message is sent.");
                    exchange = this.externalListener.createConsumeExchange(this.externalListener.getConsumes(), Message.MEPConstants.IN_ONLY_PATTERN);
                }
            }
            catch (MessagingException e) {
                this.logger.log(Level.WARNING, "No pattern specified in consumes extensions. So an in-only message is sent.");
                exchange = this.externalListener.createConsumeExchange(this.externalListener.getConsumes(), Message.MEPConstants.IN_ONLY_PATTERN);
            }
            if (jmsExchange instanceof TextMessage) {
                this.logger.log(Level.FINEST, "It's a TextMessage.");
                TextMessage textMessage = (TextMessage)jmsExchange;
                this.transform(textMessage, exchange);
            }
            this.externalListener.send(exchange);
            this.logger.log(Level.FINEST, "The message has been sent.");
        }
        catch (ClassCastException e) {
            this.logger.log(Level.SEVERE, "Only TextMessage are processed by petals-binding-jms component.", e);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getClass() + " " + e.getMessage(), e);
        }
    }

    private void transform(TextMessage jmsMessage, Exchange exchange) throws JMSException, MessagingException, PEtALSCDKException {
        this.logger.log(Level.FINE, "transform");
        String content = jmsMessage.getText();
        Source source = SourceUtil.createSource((String)content, (String)"UTF-8");
        exchange.getInMessage().setContent(source);
        this.setOperation((Message)jmsMessage, exchange);
        this.setMessageProperties((Message)jmsMessage, exchange.getInMessage());
    }

    private void setOperation(Message jmsMessage, Exchange exchange) throws JMSException {
        if (jmsMessage.getStringProperty("jms_operation_name") != null && jmsMessage.getStringProperty("jms_operation_name").length() > 0) {
            exchange.setOperation(QName.valueOf(jmsMessage.getStringProperty("jms_operation_name")));
        } else if (this.externalListener.getExtensions().get((Object)"operation") != null) {
            exchange.setOperation(QName.valueOf(this.externalListener.getExtensions().get((Object)"operation")));
        }
    }

    private void setMessageProperties(Message jmsMessage, NormalizedMessage normalizedMessage) throws JMSException {
        Enumeration it = jmsMessage.getPropertyNames();
        while (it.hasMoreElements()) {
            String jmsPropertyName = (String)it.nextElement();
            if ("jms_operation_name".equals(jmsPropertyName)) continue;
            normalizedMessage.setProperty(jmsPropertyName, jmsMessage.getObjectProperty(jmsPropertyName));
        }
    }
}

