/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.listener;

import java.io.IOException;
import java.util.logging.Level;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.bc.jms.JmsBC;
import org.ow2.petals.bc.jms.connection.JMSProviderConnection;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.SourceUtil;

public class ServiceManager {
    private AbstractJBIListener listener;

    public ServiceManager(AbstractJBIListener listener) {
        this.listener = listener;
    }

    public void onJBIMessage(Exchange exchange) throws PEtALSCDKException {
        if (!Message.MEPConstants.IN_ONLY_PATTERN.value().equals(exchange.getPattern())) {
            throw new PEtALSCDKException("MessageExchangePattern not allowed :" + exchange.getPattern());
        }
        this.sendJMSMessage(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendJMSMessage(Exchange exchange) throws PEtALSCDKException {
        JMSProviderConnection conn;
        this.listener.getLogger().log(Level.FINE, "sendJMSMessage");
        JmsBC component = (JmsBC)this.listener.getComponent();
        GenericObjectPool pool = component.getJmsProducerConnections().get(this.listener.getProvides());
        try {
            conn = (JMSProviderConnection)pool.borrowObject();
        }
        catch (Exception e1) {
            String exceptionMsg = "Can't retrieve a JMS connection linked to the following endpoint: " + exchange.getEndpoint();
            throw new PEtALSCDKException(exceptionMsg, (Throwable)e1);
        }
        try {
            if (conn == null) {
                throw new PEtALSCDKException("Can't retrieve a JMS connection linked to the following endpoint: " + exchange.getEndpoint());
            }
            this.listener.getLogger().log(Level.INFO, "Try to send JBI message to '" + conn.getDestinationName() + "' JMS provider.");
            TextMessage msg = null;
            try {
                if (exchange.getInMessage().getAttachmentNames().size() == 0) {
                    TextMessage textMsg = null;
                    textMsg = conn.getSession().createTextMessage();
                    this.transform(exchange, textMsg);
                    msg = textMsg;
                }
            }
            catch (Exception e) {
                this.listener.getLogger().log(Level.SEVERE, "Can not create the JMS message from JBI message.", e);
                if (e instanceof PEtALSCDKException) {
                    throw (PEtALSCDKException)((Object)e);
                }
                throw new PEtALSCDKException("Can not create the JMS message from JBI message.", (Throwable)e);
            }
            try {
                conn.getMessageProducer().send(msg);
                if (conn.isTransacted()) {
                    conn.getSession().commit();
                }
            }
            catch (JMSSecurityException e) {
                String exceptionMsg = "Can not send the JMS message, WRITE right not granted.";
                throw new PEtALSCDKException(exceptionMsg, (Throwable)e);
            }
            catch (JMSException e) {
                String exceptionMsg = "Can not send the JMS message.";
                throw new PEtALSCDKException(exceptionMsg, (Throwable)e);
            }
        }
        finally {
            try {
                pool.returnObject((Object)conn);
            }
            catch (Exception e) {
                String exceptionMsg = "Can't free a JMS connection of the pool.";
                throw new PEtALSCDKException(exceptionMsg, (Throwable)e);
            }
        }
        this.listener.getLogger().log(Level.INFO, "Message sent to '" + conn.getDestinationName() + "'.");
    }

    private void transform(Exchange exchange, TextMessage jmsMessage) throws JMSException, TransformerException, IOException, PEtALSCDKException {
        this.listener.getLogger().log(Level.FINE, "transform");
        NormalizedMessage in = exchange.getInMessage();
        this.setMessageProperties((Message)jmsMessage, in);
        this.setServiceOperation(exchange, (Message)jmsMessage);
        String inSourceAsString = SourceUtil.createString((Source)in.getContent());
        jmsMessage.setText(inSourceAsString);
    }

    private void setServiceOperation(Exchange exchange, Message jmsMessage) throws JMSException {
        QName operation = exchange.getOperation();
        if (operation != null) {
            jmsMessage.setStringProperty("jms_operation_name", operation.toString());
        }
    }

    private void setMessageProperties(Message jmsMessage, NormalizedMessage normalizedMessage) throws JMSException {
        for (String propertyName : normalizedMessage.getPropertyNames()) {
            Object propertyValue = normalizedMessage.getProperty(propertyName);
            jmsMessage.setObjectProperty(propertyName, propertyValue);
        }
    }
}

