/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.jms.su;

import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.bc.jms.JmsBC;
import org.ow2.petals.bc.jms.connection.JMSProviderConnectionFactory;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.BindingComponentServiceUnitManager;

public class JmsServiceUnitManager
extends BindingComponentServiceUnitManager {
    private final JmsBC component;

    public JmsServiceUnitManager(JmsBC component) {
        super((AbstractBindingComponent)component);
        this.component = component;
    }

    public void doDeploy(String serviceUnitName, String suRootPath, Jbi descriptor) throws PEtALSCDKException {
        for (Provides provides : descriptor.getServices().getProvides()) {
            try {
                this.registerConnectionPool(provides);
            }
            catch (PEtALSCDKException e) {
                throw new PEtALSCDKException("Error creating a connection pool for SU: " + suRootPath, (Throwable)e);
            }
        }
    }

    public void doStart(String serviceUnitName) throws PEtALSCDKException {
    }

    public void doStop(String serviceUnitName) throws PEtALSCDKException {
    }

    public void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        for (ServiceEndpoint endpoint : this.getEndpointsForServiceUnit(serviceUnitName)) {
            Provides provides = this.getProvidesFromEndpoint(endpoint);
            try {
                this.unregisterConnectionPool(provides);
            }
            catch (PEtALSCDKException e) {
                throw new PEtALSCDKException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void registerConnectionPool(Provides provides) throws PEtALSCDKException {
        ConfigurationExtensions extensions = new ConfigurationExtensions(provides.getAny());
        if (extensions != null) {
            int maxActive = Integer.parseInt(extensions.get((Object)"max-active", "10"));
            long maxWait = Long.parseLong(extensions.get((Object)"max-wait", "10000"));
            int maxIdle = Integer.parseInt(extensions.get((Object)"max-idle", "5"));
            long timeBetweenEvictionTimeMillis = Long.parseLong(extensions.get((Object)"time-between-eviction-run-smillis", "30000"));
            long minEvictableIdleTimeMillis = Long.parseLong(extensions.get((Object)"min-evictable-idle-time-millis", "600000"));
            boolean testWhileIdle = Boolean.parseBoolean(extensions.get((Object)"test-while-idle", "true"));
            this.component.getJmsProducerConnections().put(provides, new GenericObjectPool((PoolableObjectFactory)new JMSProviderConnectionFactory(extensions, this.component.getLogger()), maxActive, 1, maxWait, maxIdle, false, false, timeBetweenEvictionTimeMillis, 5, minEvictableIdleTimeMillis, testWhileIdle));
        }
    }

    private void unregisterConnectionPool(Provides provides) throws PEtALSCDKException {
        GenericObjectPool pool = this.component.getJmsProducerConnections().get(provides);
        try {
            pool.close();
        }
        catch (Exception e) {
            throw new PEtALSCDKException("Can't close pool associated to provides node : " + provides);
        }
        this.component.getJmsProducerConnections().remove(provides);
    }
}

