package org.ow2.petals.bc.mail.steps;

import java.io.ByteArrayInputStream;

import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;

import org.hamcrest.Matchers;
import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.Alias
import org.jbehave.core.annotations.BeforeStories
import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When
import org.jbehave.core.model.ExamplesTable
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.OutcomesTable.OutcomesFailed;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.bc.mail.MailComponent;
import org.ow2.petals.bc.mail.MailConstants;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.ow2.petals.components.steps.AbstractComponentSteps;
import org.ow2.petals.components.steps.AbstractOrchestratorComponentSteps;
import org.ow2.petals.components.stories.util.LogInfoFinder;
import org.ow2.petals.components.stories.util.RegexMatcher;
import org.jbehave.core.steps.Parameters;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedComponent;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage;
import static org.ow2.petals.components.stories.util.StoryContext.*;


class AbstractMailComponentSteps extends AbstractOrchestratorComponentSteps {

    static final String OPERATION_PARAM_NAME = new QName("http://petals.ow2.org/components/extensions/version-5", "operation").toString();
    static final String POLLING_PERIOD_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.PERIOD_QUERYELEMENT).toString();
    static final String HOST_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.HOST_PATHELEMENT).toString();
    static final String SCHEME_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.SCHEME_PATHELEMENT).toString();
    static final String SCHEME_PORT_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.PORT_PATHELEMENT).toString();
    static final String USER_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.USER_PATHELEMENT).toString();
    static final String PASSWORD_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.PASSWORD_PATHELEMENT).toString();
    static final String FROM_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.FROM_PATHELEMENT).toString();
    static final String TO_PARAM_NAME = new QName(MailConstants.MAIL_SERVICE_NS, MailConstants.TO_PATHELEMENT).toString();


    @Given("a mail server installed on <mailHost> with <scheme> enabled on port <schemePort>")
    def aMailServerStartedWithSchemeEnabled(String mailHost, String scheme, int schemePort) {
        this.mailHost = mailHost;
        this.scheme = scheme;
        this.schemePort = schemePort;
        if( schemePort != mailServer.getSchemePort(scheme)) {
            mailServer.killAll();
            switch (scheme) {
                case JamesServer.POP3_SCHEME:
                    mailServer = new JamesServer(pop3Port:schemePort);
                    break;
                case JamesServer.IMAP_SCHEME:
                    mailServer = new JamesServer(imapPort:schemePort);
                    break;
                case JamesServer.SMTP_SCHEME:
                    mailServer = new JamesServer(smtpPort:schemePort);
                    break;
                default:
                    break;
            }
            mailServer.launch();
        }
        // TODO mailHost not used for now
    }

    @Given("a mailbox hosted on this mail server reachable at <user>@<domain> with password <password>")
    def aMailboxHostedOnThisMailServer(String user, String domain, String password) {
        this.user = user;
        this.domain = domain;
        this.password = password;

        mailServer.reset();
        mailServer.addMailbox(user, password, domain);
    }
}

