package org.ow2.petals.bc.mail.steps;

import java.io.ByteArrayInputStream;

import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;

import org.hamcrest.Matchers;
import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.Alias
import org.jbehave.core.annotations.BeforeStories
import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When
import org.jbehave.core.model.ExamplesTable
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.OutcomesTable.OutcomesFailed;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.bc.mail.MailComponent;
import org.ow2.petals.bc.mail.MailConstants;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.ow2.petals.components.steps.AbstractComponentSteps
import org.ow2.petals.components.stories.util.LogInfoFinder;
import org.ow2.petals.components.stories.util.RegexMatcher;
import org.jbehave.core.steps.Parameters;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedComponent;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.JbiConstants;
import com.ebmwebsourcing.jbi.adaptor.impl.transport.RequestResponseTransporter;
import static org.ow2.petals.components.stories.util.StoryContext.*;


class IdentifyMailConsumerBeginStepSteps extends AbstractMailComponentSteps {
    
    @Given("""a mail component <componentName> is configured on <nodeName> 
              to poll this mailbox every <pollingPeriod> second(s) 
              so that receiving an email is bound to invocation of this jsr-181 service""")
    public void aMailComponentConfiguredOToPollThisMailboxSoThatReceivingAnEmailIsBoundToJSR181Service(
    String componentName,
    String nodeName,
    int pollingPeriod){
        this.component = createAndStartComponent(ComponentType.BC_MAIL, createComponentConfiguration(componentName));

        ServiceConfiguration consumeServiceConfiguration = new ServiceConfiguration("IdentifyMailConsumer",
                this.provideJsr181ServiceConfiguration.getInterfaceQName(),
                this.provideJsr181ServiceConfiguration.getServiceQName(),
                this.provideJsr181ServiceConfiguration.getEndpointName(),
                ServiceConfiguration.ServiceType.CONSUME);
        consumeServiceConfiguration.setParameter("{"
                + JbiConstants.CDK_NAMESPACE_URI + "}"
                + "operation", this.provideJsr181OperationName);
        consumeServiceConfiguration.setParameter(SCHEME_PARAM_NAME, this.scheme);
        consumeServiceConfiguration.setParameter(HOST_PARAM_NAME, this.mailHost);
        consumeServiceConfiguration.setParameter(SCHEME_PORT_PARAM_NAME, String.valueOf(this.schemePort));
        consumeServiceConfiguration.setParameter(USER_PARAM_NAME, this.user + "@" +
                this.domain);
        consumeServiceConfiguration.setParameter(PASSWORD_PARAM_NAME, this.password);
        consumeServiceConfiguration.setParameter(POLLING_PERIOD_PARAM_NAME, String.valueOf(pollingPeriod * 1000));

        this.component.installService(consumeServiceConfiguration);
    }
    
    @When("an email is sent to this mailbox")
    def anEmailSentToThisMailbox() {
        mailServer.sendEmail("from", user+"@"+domain, "subject", "content");
        RequestResponseTransporter requestResponseTransporter = new RequestResponseTransporter(this.component, this.jsr181Component);
        requestResponseTransporter.transport();
    }
}

