package org.ow2.petals.bc.mail.steps;

import java.io.ByteArrayInputStream;

import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;

import org.hamcrest.Matchers;
import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.Alias
import org.jbehave.core.annotations.BeforeStories
import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When
import org.jbehave.core.model.ExamplesTable
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.OutcomesTable.OutcomesFailed;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.bc.mail.MailComponent;
import org.ow2.petals.bc.mail.MailConstants;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.ow2.petals.components.steps.AbstractComponentSteps
import org.ow2.petals.components.stories.util.LogInfoFinder;
import org.ow2.petals.components.stories.util.RegexMatcher;
import org.jbehave.core.steps.Parameters;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedComponent;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage;
import static org.ow2.petals.components.stories.util.StoryContext.*;

class IdentifyMailProviderBeginStepSteps extends AbstractMailComponentSteps {

    @Given("""a mail component <componentName> configured on <nodeName>
              imports this mailbox as an internal service
              <interfaceName>,<serviceName>,<endpointName>""")
    def aMailComponentConfiguredToImportThisMailBox(
    String nodeName,
    String componentName,
    String interfaceName,
    String serviceName,
    String endpointName) {
        this.component = createAndStartComponent(ComponentType.BC_MAIL, createComponentConfiguration(componentName));

        ServiceConfiguration thisInternalService = new ServiceConfiguration("identifyMailProvideStep",
                QName.valueOf(interfaceName),
                QName.valueOf(serviceName),
                endpointName,
                ServiceConfiguration.ServiceType.PROVIDE);

        thisInternalService.setParameter(SCHEME_PARAM_NAME, scheme);
        thisInternalService.setParameter(HOST_PARAM_NAME, mailHost);
        thisInternalService.setParameter(SCHEME_PORT_PARAM_NAME, String.valueOf(schemePort));
        thisInternalService.setParameter(FROM_PARAM_NAME, user + "@" + domain);
        thisInternalService.setParameter(TO_PARAM_NAME, user + "@" + domain);

        this.thisInternalService = thisInternalService;
        component.installService(thisInternalService);
    }

    @When("""a request is received by this internal service with the operation <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    public void aRequestIsReceivedByThisInternalService(
    String operationName, String flowInstanceId, String previousStepId) {

        def requestMessage = new WrappedRequestMessage(thisInternalService, QName.valueOf(operationName),
                AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                createPayloadInputStream("<?xml version='1.0' encoding='UTF-8'?><mail><body>My Mail Content</body></mail>"),
                new FlowAttributes(flowInstanceId, previousStepId));

        component.pushMessage(requestMessage);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

