Story: identify mail consumer end step 

Scenario: thanks to MONIT log record for InOnly message exchange pattern

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a jsr-181 component <providerComponentName> configured on <nodeName>
so that operation <providerOperationName> of internal service 
<providerInterfaceName>,<providerServiceName>,<providerEndpointName> is bound to java method execution

Given a mail server installed on <mailHost> with <scheme> enabled on port <schemePort>
And a mailbox hosted on this mail server reachable at <user>@<domain> with password <password>

Given a mail component <componentName> is configured on <nodeName> 
to poll this mailbox every <pollingPeriod> second(s) 
so that receiving an email is bound to invocation of this jsr-181 service

When an email is sent to this mailbox


Then after <processingDelay> second(s), a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key             | matcher | value |
| traceCode       | equals  | consumeFlowStepBegin |
| flowInstanceId  | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
| flowStepId      | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
|flowInterfaceName| equals  | providerInterfaceName |
|flowServiceName  | equals  | providerServiceName |
|flowEndpointName | equals  | providerEndpointName |
|flowOperationName| equals  | providerOperationName |
|scheme           | equals  | scheme |
|host             | equals  | mailHost |
|port             | equals  | schemePort |
|user             | equals  | user@domain |
|folder           | equals  | INBOX |

Then after first record, an other MONIT record, known as second record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | providerInterfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  providerServiceName                                                |                                                                             
| flowStepEndpointName  | equals  |  providerEndpointName                                               |                                                                             
| flowStepOperationName | equals  |  providerOperationName                                              |                                                                             
| flowPreviousStepId    |regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then after second record, an other MONIT record, known as third record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  provideFlowStepEnd                                          |
| flowInstanceId | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then after second record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  consumeFlowStepEnd                                          |
| flowInstanceId | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then flowStepId of first record must be equal to flowStepId of fourth record
Then flowStepId of second record must be equal to flowStepId of third record
Then flowInstanceId of all records must be the same
Then flowPreviousStepId of second record must be equal to flowStepId of first record

Examples:
| nodeHost  | nodeName | componentName   | user  | domain      | password  | schemePort | mailHost  | scheme | providerInterfaceName                   | providerServiceName                          | providerEndpointName  | providerOperationName                    | providerComponentName | pollingPeriod | processingDelay|
| localhost | node1    | petals-bc-mail1 | user1 | domain1.org | password1 | 8110       | localhost | pop3   | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOnlyOperation | petals-se-jsr-181    | 2             | 5              |
