Story: identify mail provider end step

Scenario: with MONIT log level

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a mail server installed on <mailHost> with <scheme> enabled on port <schemePort>
And a mailbox hosted on this mail server reachable at <user>@<domain> with password <password>

Given a mail component <componentName> configured on <nodeName>
imports this mailbox as an internal service
<interfaceName>,<serviceName>,<endpointName>

When a request is received by this internal service with the operation <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value                                                         |
| traceCode             | equals  | provideFlowStepBegin                                         |
| flowInstanceId        | equals   | flowInstanceId |
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
| flowStepInterfaceName | equals  | interfaceName                                              |
| flowStepServiceName   | equals  | serviceName                                                |
| flowStepEndpointName  | equals  | endpointName                                              |
| flowStepOperationName | equals  | operationName                                             |
| flowPreviousStepId    | equals  | previousStepId |

And later, an other MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key            | matcher | value                                                         |
| traceCode      | equals  | provideFlowStepEnd                                            |
| flowInstanceId | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}  |
| flowStepId     | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}  |

And flowStepId of first record must be equal to flowStepId of the other record
And flowInstanceId of first record must be equal to flowInstanceId of the other record

Examples:
| nodeHost | nodeName | user | domain | password | scheme | mailHost | schemePort | componentName | interfaceName | serviceName | endpointName | operationName | flowInstanceId                       | previousStepId |
| localhost | localhost | user1 | domain1.org | password1 | smtp | localhost | 8025 | petals-bc-mail1 | {http://petalslink.org}interfaceName1 | {http://petalslink.org}serviceName1 | endpointName1 | {http://petals.ow2.org/components/mail/version-3}SendMail |ec7507e0-f01f-11e0-8411-0024e8b3e525 | ps7507e0-f01f-11e0-8411-0024e8b3e525 |
