/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.bc.mail.MailBCImpl;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.listeners.MailBCExternalScheduler;
import org.ow2.petals.bc.mail.listeners.MailSessionManager;
import org.ow2.petals.bc.mail.listeners.MimeMessageManager;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.bc.mail.listeners.SessionDescriptorBuilder;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MailBCExternalListener
extends AbstractExternalListener {
    protected ConfigurationExtensions extensions;
    protected MailSessionManager mailSessionManager;
    protected MimeMessageManager mimeMessageManager;
    protected SessionDescriptorBuilder sessionDescriptorBuilder;
    private Timer timer;

    public void init() {
        this.mailSessionManager = ((MailBCImpl)this.getComponent()).getMailSessionManager();
        this.sessionDescriptorBuilder = ((MailBCImpl)this.getComponent()).getSessionDescriptorBuilder();
        this.mimeMessageManager = ((MailBCImpl)this.getComponent()).getMimeMessageManager();
    }

    protected void process(Message message) {
        this.getLogger().info("process an incoming email");
        Exchange exchange = null;
        try {
            exchange = this.createConsumeExchange(this.getConsumes(), Message.MEPConstants.IN_ONLY_PATTERN);
            this.setJBIContentAndAttachments(message, exchange);
            this.setProperties(message, exchange);
        }
        catch (MessagingException e) {
            this.getLogger().log(Level.WARNING, "error with JBI Exchange creation", e);
        }
        catch (PEtALSCDKException e) {
            this.getLogger().log(Level.WARNING, "error with XML Normalized message creation", e);
        }
        catch (javax.mail.MessagingException e) {
            this.getLogger().log(Level.WARNING, "error with email access", e);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "error with email access", e);
        }
        try {
            this.send(exchange);
        }
        catch (MessagingException e) {
            this.getLogger().log(Level.WARNING, "the JBI Exchange can not be sent", e);
            try {
                message.setFlag(Flags.Flag.DELETED, false);
            }
            catch (javax.mail.MessagingException e1) {
                this.getLogger().log(Level.WARNING, "error with email access", e);
            }
        }
    }

    protected void setJBIContentAndAttachments(Part message, Exchange exchange) throws IOException, javax.mail.MessagingException, MessagingException, PEtALSCDKException {
        Object content = message.getContent();
        if (content instanceof String) {
            if (exchange.getInMessageContentAsSource() == null) {
                if ("true".equals(this.getExtensions().get((Object)"isxmlcontent"))) {
                    this.getLogger().info("An XML part is set to JBI Exchange content");
                    exchange.setInMessageContent((Source)new StreamSource(new StringReader(content.toString())));
                } else {
                    this.getLogger().info("A text part is set to JBI Exchange content (wrap in <body> element)");
                    Document doc = XMLUtil.createDocument();
                    Element bodyElmt = doc.createElement("body");
                    bodyElmt.setTextContent(content.toString());
                    doc.appendChild(bodyElmt);
                    doc.normalize();
                    exchange.setInMessageContent(doc);
                }
            } else {
                this.getLogger().warning("a text part is found, but the JBI Exchange content has been already set");
            }
        } else if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.setJBIContentAndAttachments(mp.getBodyPart(i), exchange);
            }
        } else if (content instanceof InputStream) {
            this.getLogger().info("add an attachment on JBI Exchange");
            exchange.addInMessageAttachment(message.getFileName(), message.getDataHandler());
        }
    }

    protected void setProperties(Message message, Exchange exchange) throws javax.mail.MessagingException {
        StringBuilder s_from = new StringBuilder();
        Address[] addresses = message.getFrom();
        if (addresses != null) {
            for (Address from : addresses) {
                s_from.append(from.toString()).append(";");
            }
            s_from.deleteCharAt(s_from.length() - 1);
        }
        StringBuilder s_reply = new StringBuilder();
        addresses = message.getReplyTo();
        if (addresses != null) {
            for (Address reply : addresses) {
                s_reply.append(reply.toString()).append(";");
            }
            if (s_reply.length() > 0) {
                s_reply.deleteCharAt(s_reply.length() - 1);
            }
        }
        if ((addresses = message.getAllRecipients()) != null) {
            StringBuilder s_to = new StringBuilder();
            for (Address to : addresses) {
                s_to.append(to.toString()).append(";");
            }
            if (s_to.length() > 0) {
                s_to = s_to.deleteCharAt(s_to.length() - 1);
            }
        }
        String s_subject = message.getSubject();
        this.getLogger().fine("set property " + Constants.FROM_QNAME + " : " + s_from);
        exchange.getInMessage().setProperty(Constants.FROM_QNAME.toString(), (Object)s_from);
        if (s_reply.length() > 0) {
            this.getLogger().fine("set property " + Constants.REPLY_TO_QNAME + " : " + s_reply);
            exchange.getInMessage().setProperty(Constants.REPLY_TO_QNAME.toString(), (Object)s_reply);
        }
        if (s_subject != null && s_subject.length() > 0) {
            this.getLogger().fine("set property " + Constants.ACTION_QNAME + " : " + s_subject);
            exchange.getInMessage().setProperty(Constants.ACTION_QNAME.toString(), (Object)s_subject);
        }
    }

    public void start() throws PEtALSCDKException {
        this.extensions = new ConfigurationExtensions(this.getConsumes().getAny());
        try {
            this.timer = new Timer();
            SessionDescriptor sessionDescriptor = this.sessionDescriptorBuilder.build(this.extensions);
            MailBCExternalScheduler listener = new MailBCExternalScheduler(this.getLogger(), this, sessionDescriptor, this.mailSessionManager);
            this.timer.schedule((TimerTask)listener, 0L, (long)Integer.parseInt(sessionDescriptor.getPeriod()));
        }
        catch (MissingElementException e) {
            this.getLogger().warning("Missing element in the jbi.xml : " + e.getElement());
        }
    }

    public void stop() throws PEtALSCDKException {
        this.timer.cancel();
    }
}

