/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.ow2.petals.bc.mail.listeners.MailBCExternalListener;
import org.ow2.petals.bc.mail.listeners.MailSessionManager;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;

public class MailBCExternalScheduler
extends TimerTask {
    private final transient MailBCExternalListener externalListener;
    protected final transient Logger logger;
    protected transient MailSessionManager mailSessionManager;
    protected transient SessionDescriptor sessionDescriptor;

    public MailBCExternalScheduler(Logger log, MailBCExternalListener externalListener, SessionDescriptor sessionDescriptor, MailSessionManager mailSessionManager) {
        this.logger = log;
        this.externalListener = externalListener;
        this.mailSessionManager = mailSessionManager;
        this.sessionDescriptor = sessionDescriptor;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Message> messages = null;
        Folder folder = null;
        Store store = null;
        try {
            Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(this.sessionDescriptor);
            store = this.mailSessionManager.getStoreAndConnect(session, this.sessionDescriptor);
            folder = this.mailSessionManager.getFolderAndOpen(store, this.sessionDescriptor);
            messages = this.mailSessionManager.getNewMails(folder);
            for (Message message : messages) {
                this.externalListener.process(message);
                message.setFlag(Flags.Flag.DELETED, true);
            }
            this.mailSessionManager.closeFolderAndStore(folder, store, this.sessionDescriptor.isDelete());
        }
        catch (MessagingException e) {
            try {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                this.mailSessionManager.closeFolderAndStore(folder, store, this.sessionDescriptor.isDelete());
            }
            catch (Throwable throwable) {
                this.mailSessionManager.closeFolderAndStore(folder, store, this.sessionDescriptor.isDelete());
                throw throwable;
            }
        }
    }
}

