/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.bc.mail.MailBCImpl;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.listeners.MailSessionManager;
import org.ow2.petals.bc.mail.listeners.MimeMessageManager;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.bc.mail.listeners.SessionDescriptorBuilder;
import org.ow2.petals.bc.mail.service.SendMailGenericService;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.UtilFactory;

public class MailBCJBIListener
extends AbstractJBIListener {
    protected MailSessionManager mailSessionManager;
    protected MimeMessageManager mimeMessageManager;
    protected SessionDescriptorBuilder sessionDescriptorBuilder;
    protected SendMailGenericService sendMailService;

    private static final boolean validateExchange(Exchange exchange) {
        boolean result = true;
        QName operation = exchange.getOperation();
        if (operation == null) {
            exchange.setError(new Exception("Operation '" + operation + "' must be in the namespace '" + "http://petals.ow2.org/components/mail/version-3" + "'"));
            result = false;
        }
        return result;
    }

    public void init() {
        this.mimeMessageManager = ((MailBCImpl)this.getComponent()).getMimeMessageManager();
        this.mailSessionManager = ((MailBCImpl)this.getComponent()).getMailSessionManager();
        this.sessionDescriptorBuilder = ((MailBCImpl)this.getComponent()).getSessionDescriptorBuilder();
        this.sendMailService = new SendMailGenericService(this.mailSessionManager, this.mimeMessageManager, this.sessionDescriptorBuilder, this.getLogger());
    }

    public boolean onJBIMessage(Exchange exchange) {
        if (!MailBCJBIListener.validateExchange(exchange)) {
            this.getLogger().log(Level.WARNING, exchange.getError().getMessage());
            return true;
        }
        if (exchange.getFault() == null) {
            try {
                if (!exchange.isInOnlyPattern()) {
                    throw new JBIException("Exchange pattern for the " + exchange.getOperation() + " operation must be " + Message.MEPConstants.IN_ONLY_PATTERN);
                }
                if (UtilFactory.getWSDLUtil().isDescriptionContaining(this.component.getNativeWsdl().getDescription(), exchange.getEndpoint())) {
                    this.sendMailService.sendMailGenericService(exchange);
                } else {
                    this.standardSendService(exchange);
                }
            }
            catch (WSDLException e) {
                this.getLogger().warning("Error on wsdl reading: " + e.getMessage());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, e.getClass().getSimpleName() + " : " + e.getMessage());
                exchange.setError((Exception)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)e)));
            }
        }
        return true;
    }

    protected void standardSendService(Exchange exchange) throws JBIException {
        block4: {
            try {
                this.getLogger().log(Level.INFO, "JBI Exchange received - send it as a mail");
                ConfigurationExtensions extensions = this.getExtensions();
                SessionDescriptor sessionDescriptor = this.sessionDescriptorBuilder.build(extensions);
                Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(sessionDescriptor);
                MimeMessage mimeMessage = this.mimeMessageManager.mapNormalizedMessageToMimeMessage(session, sessionDescriptor, exchange.getInMessage());
                this.mailSessionManager.sendMail(mimeMessage, sessionDescriptor, session);
                this.getLogger().log(Level.INFO, "email sent to " + sessionDescriptor.getToAddress());
            }
            catch (MissingElementException missingException) {
                this.getLogger().warning("Service unit send mail service : Missing element in the jbi.xml of the su  : " + missingException.getElement());
                if (!exchange.isInOnlyPattern()) {
                    this.sessionDescriptorBuilder.setMissingElementFaultOnExchange(exchange, missingException.getElement());
                }
            }
            catch (MessagingException me) {
                this.getLogger().log(Level.WARNING, "sendMail can not send the mail", me);
                if (exchange.isInOnlyPattern()) break block4;
                this.sessionDescriptorBuilder.setIOFaultOnExchange(exchange, me.getMessage());
            }
        }
    }
}

