/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.util.UtilFactory;

public class MimeMessageManager {
    protected AbstractBindingComponent component;
    protected Logger log;

    public MimeMessageManager(Logger log, AbstractBindingComponent component) {
        this.log = log;
        this.component = component;
    }

    public MimeMessage mapNormalizedMessageToMimeMessage(Session session, SessionDescriptor descriptor, NormalizedMessage in) throws JBIException {
        this.log.finest("create email from JBI Exchange");
        MimeMessage mimeMessage = new MimeMessage(session);
        String sendMode = descriptor.getSendMode();
        this.setMimeMessageAttributes(mimeMessage, descriptor.getToAddress(), descriptor.getFromAddress(), descriptor.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        if (!sendMode.equalsIgnoreCase("attachments-only")) {
            this.setMimeMessageBody((Multipart)multipart, in);
        }
        if (!sendMode.equalsIgnoreCase("content-only")) {
            this.setMimeMessageAttachments(multipart, in);
        }
        try {
            mimeMessage.setContent(multipart);
        }
        catch (MessagingException e) {
            String msg = "Error setting Mime message contentwith all information collected from NormalizedMessage";
            this.log.warning("Error setting Mime message contentwith all information collected from NormalizedMessage");
            throw new JBIException("Error setting Mime message contentwith all information collected from NormalizedMessage", (Throwable)e);
        }
        return mimeMessage;
    }

    protected void setMimeMessageAttachments(Multipart multipart, NormalizedMessage in) {
        this.log.finest("set the email attachments");
        Set attachmentIds = in.getAttachmentNames();
        MimeBodyPart attachementBodyPart = null;
        DataHandler handler = null;
        if (attachmentIds != null) {
            for (String id : attachmentIds) {
                handler = in.getAttachment(id);
                this.log.finest("add " + id + " as MimeMessage attachment.");
                attachementBodyPart = new MimeBodyPart();
                try {
                    attachementBodyPart.setDataHandler(handler);
                    attachementBodyPart.setFileName(id);
                    multipart.addBodyPart(attachementBodyPart);
                }
                catch (MessagingException e) {
                    String msg = "Error setting MimeMessage attachments " + id;
                    this.log.warning(msg);
                }
            }
        }
    }

    protected void setMimeMessageAttributes(MimeMessage mimeMessage, String toAddress, String fromAddress, String subject) throws JBIException {
        this.log.finest("set the email attributes");
        try {
            InternetAddress toInternetAddress = new InternetAddress(toAddress);
            InternetAddress fromInternetAddress = new InternetAddress(fromAddress);
            mimeMessage.setRecipient(Message.RecipientType.TO, toInternetAddress);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setFrom(fromInternetAddress);
            mimeMessage.setSubject(subject);
        }
        catch (MessagingException e) {
            String msg = "Error setting MimeMessage attributes";
            this.log.warning("Error setting MimeMessage attributes");
            throw new JBIException("Error setting MimeMessage attributes", (Throwable)e);
        }
    }

    protected void setMimeMessageBody(Multipart multipart, NormalizedMessage in) throws JBIException {
        String content = null;
        try {
            if (in.getContent() != null) {
                content = UtilFactory.getSourceUtil().createString(in.getContent());
                this.setMimeMessageBody(multipart, content);
            }
        }
        catch (Exception e) {
            throw new JBIException(e.getMessage());
        }
    }

    protected void setMimeMessageBody(Multipart multipart, String content) throws MessagingException {
        this.log.finest("set the email body");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent(content, "text/plain");
        multipart.addBodyPart(messageBodyPart);
    }
}

