package org.ow2.petals.bc.sftp.steps;

import java.io.File
import java.io.FileWriter

import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.BeforeStories
import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.ow2.petals.components.steps.AbstractComponentSteps


class AbstractSftpComponentSteps extends AbstractComponentSteps {


    @Given("a sftp server installed on the port <sftpPort> of <sftpHost>")
    def startSftpServer(
        int sftpPort,
        String sftpHost) {
        if(!this.sshd.sshdHost.equals(sftpHost) || this.sshd.sshdPort != sftpPort) {
            this.sshd.stop();
            this.sshd = new SshdServer();
            this.sshd.sshdHost = sftpHost;
            this.sshd.sshdPort = sftpPort;
            this.sshd.start();
        }
    }

    @Given("an account <user> / <password> on this sftp server")
    def theSftpAccount(
        String user,
        String password) {
        this.user =user;
        this.password = password;
        this.sshd.addUser(user, password);
    }

    @Given("a file <fileName> available on this sftp server")
    def fileAvailableOnSftpServer(
        String fileName) {
        this.fileName = fileName;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(this.sshd.workingDir, fileName));
            fileWriter.write("<test>This is the file to get or delete</test>");
        } finally {
            if(fileWriter != null) {
                fileWriter.close();
            }
        }
    }
}

