package org.ow2.petals.bc.sftp.steps;

import static org.ow2.petals.components.stories.util.StoryContext.*

import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.BeforeStories
import org.ow2.petals.components.steps.AbstractComponentSteps



class BeforeAndAfterSteps extends AbstractComponentSteps {


    @BeforeStories
    def startSshdServer() {
        this.sshd = new SshdServer();
        this.sshd.start();
    }

    @AfterStories
    def stopSshdServer() {
        try {
            this.sshd.stop();
        } catch (NullPointerException npe) {
            // sshd server might already be stopped.
            // there is an ownership problem on sshserver wrapping class.
        }
    }

    @AfterScenario
    def afterScenario() {
        this.sshd.reset();
    }
}

