package org.ow2.petals.bc.sftp.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.bc.sftp.SFTPConstants
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage


class IdentifySftpProviderBeginStepSteps extends AbstractSftpComponentSteps {

    ServiceConfiguration provideServiceConfiguration;

    @Given("""a sftp component <componentName> configured on <nodeName>
    imports this external server as an internal service
    <interfaceName>,<serviceName>,<endpointName>""")
    def importExternalFileAsService(
        String componentName,
        String nodeName,
        String interfaceName,
        String serviceName,
        String endpointName) {
        this.component = createAndStartComponent(ComponentType.BC_SFTP, createComponentConfiguration(componentName));

        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;
        this.provideServiceConfiguration = new ServiceConfiguration("identifySftpProvideStep",QName.valueOf(interfaceName),QName.valueOf(serviceName),endpointName, role);
        this.provideServiceConfiguration.setParameter("{" + SFTPConstants.SFTP_SERVICE_NS+"}" + SFTPConstants.SFTP_SERVER, this.sshd.sshdHost);
        this.provideServiceConfiguration.setParameter("{" + SFTPConstants.SFTP_SERVICE_NS+"}" + SFTPConstants.SFTP_PORT, String.valueOf(this.sshd.sshdPort));
        this.provideServiceConfiguration.setParameter("{" + SFTPConstants.SFTP_SERVICE_NS+"}" + SFTPConstants.SFTP_USER, this.user);
        this.provideServiceConfiguration.setParameter("{" + SFTPConstants.SFTP_SERVICE_NS+"}" + SFTPConstants.SFTP_PASSWORD, this.password);
        this.component.installService(this.provideServiceConfiguration);
    }

    @When("""a request is received by this internal service with <operationName>,
    the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByService(
        String operationName,
        String flowInstanceId,
        String previousStepId) {
        Message message;
        if(operationName.equals("{http://petals.ow2.org/components/sftp/version-1}get")) {
            String payload = "<ver:get xmlns:ver='http://petals.ow2.org/components/sftp/version-1'><ver:filename>" + this.fileName + "</ver:filename></ver:get>";
            message = new WrappedRequestMessage(provideServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        } else {
            String payload = "<ver:del xmlns:ver='http://petals.ow2.org/components/sftp/version-1'><ver:filename>" + this.fileName+ "</ver:filename></ver:del>";
            message = new WrappedRequestMessage(provideServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        }

        this.component.pushMessage(message);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

